/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.internal.SearchContext;

public abstract class PipelineAggregator
implements Streamable {
    public static final Function<Aggregation, InternalAggregation> AGGREGATION_TRANFORM_FUNCTION = new Function<Aggregation, InternalAggregation>(){

        @Override
        public InternalAggregation apply(Aggregation input) {
            return (InternalAggregation)input;
        }
    };
    private String name;
    private String[] bucketsPaths;
    private Map<String, Object> metaData;

    protected PipelineAggregator() {
    }

    protected PipelineAggregator(String name, String[] bucketsPaths, Map<String, Object> metaData) {
        this.name = name;
        this.bucketsPaths = bucketsPaths;
        this.metaData = metaData;
    }

    public String name() {
        return this.name;
    }

    public String[] bucketsPaths() {
        return this.bucketsPaths;
    }

    public Map<String, Object> metaData() {
        return this.metaData;
    }

    public abstract InternalAggregation.Type type();

    public abstract InternalAggregation reduce(InternalAggregation var1, InternalAggregation.ReduceContext var2);

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringArray(this.bucketsPaths);
        out.writeMap(this.metaData);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public final void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.bucketsPaths = in.readStringArray();
        this.metaData = in.readMap();
        this.doReadFrom(in);
    }

    protected abstract void doReadFrom(StreamInput var1) throws IOException;

    public static interface Parser {
        public static final ParseField BUCKETS_PATH = new ParseField("buckets_path", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
        public static final ParseField GAP_POLICY = new ParseField("gap_policy", new String[0]);

        public String type();

        public PipelineAggregatorFactory parse(String var1, XContentParser var2, SearchContext var3) throws IOException;
    }
}

