/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.transport.TransportRequest;

public class ShardFetchRequest
extends TransportRequest {
    private long id;
    private int[] docIds;
    private int size;
    private ScoreDoc lastEmittedDoc;

    public ShardFetchRequest() {
    }

    public ShardFetchRequest(SearchScrollRequest request, long id, IntArrayList list, ScoreDoc lastEmittedDoc) {
        super(request);
        this.id = id;
        this.docIds = list.buffer;
        this.size = list.size();
        this.lastEmittedDoc = lastEmittedDoc;
    }

    protected ShardFetchRequest(TransportRequest originalRequest, long id, IntArrayList list, ScoreDoc lastEmittedDoc) {
        super(originalRequest);
        this.id = id;
        this.docIds = list.buffer;
        this.size = list.size();
        this.lastEmittedDoc = lastEmittedDoc;
    }

    public long id() {
        return this.id;
    }

    public int[] docIds() {
        return this.docIds;
    }

    public int docIdsSize() {
        return this.size;
    }

    public ScoreDoc lastEmittedDoc() {
        return this.lastEmittedDoc;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        this.size = in.readVInt();
        this.docIds = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.docIds[i] = in.readVInt();
        }
        byte flag = in.readByte();
        if (flag == 1) {
            this.lastEmittedDoc = Lucene.readFieldDoc(in);
        } else if (flag == 2) {
            this.lastEmittedDoc = Lucene.readScoreDoc(in);
        } else if (flag != 0) {
            throw new IOException("Unknown flag: " + flag);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        out.writeVInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeVInt(this.docIds[i]);
        }
        if (this.lastEmittedDoc == null) {
            out.writeByte((byte)0);
        } else if (this.lastEmittedDoc instanceof FieldDoc) {
            out.writeByte((byte)1);
            Lucene.writeFieldDoc(out, (FieldDoc)this.lastEmittedDoc);
        } else {
            out.writeByte((byte)2);
            Lucene.writeScoreDoc(out, this.lastEmittedDoc);
        }
    }
}

