/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.warmer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class IndexWarmersMetaData
extends AbstractDiffable<IndexMetaData.Custom>
implements IndexMetaData.Custom {
    public static final String TYPE = "warmers";
    public static final IndexWarmersMetaData PROTO = new IndexWarmersMetaData(new Entry[0]);
    private final List<Entry> entries;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexWarmersMetaData that = (IndexWarmersMetaData)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public IndexWarmersMetaData(Entry ... entries) {
        this.entries = Arrays.asList(entries);
    }

    public List<Entry> entries() {
        return this.entries;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public IndexWarmersMetaData readFrom(StreamInput in) throws IOException {
        Entry[] entries = new Entry[in.readVInt()];
        for (int i = 0; i < entries.length; ++i) {
            String name = in.readString();
            String[] types = in.readStringArray();
            BytesReference source = null;
            if (in.readBoolean()) {
                source = in.readBytesReference();
            }
            Boolean queryCache = in.readOptionalBoolean();
            entries[i] = new Entry(name, types, queryCache, source);
        }
        return new IndexWarmersMetaData(entries);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.entries().size());
        for (Entry entry : this.entries()) {
            out.writeString(entry.name());
            out.writeStringArray(entry.types());
            if (entry.source() == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeBytesReference(entry.source());
            }
            out.writeOptionalBoolean(entry.requestCache());
        }
    }

    @Override
    public IndexWarmersMetaData fromMap(Map<String, Object> map) throws IOException {
        if (map.size() == 1 && map.containsKey(TYPE)) {
            map = (Map)map.values().iterator().next();
        }
        XContentBuilder builder = XContentFactory.smileBuilder().map(map);
        try (XContentParser parser = XContentFactory.xContent(XContentType.SMILE).createParser(builder.bytes());){
            parser.nextToken();
            IndexWarmersMetaData indexWarmersMetaData = this.fromXContent(parser);
            return indexWarmersMetaData;
        }
    }

    @Override
    public IndexWarmersMetaData fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            String name = currentFieldName;
            ArrayList<String> types = new ArrayList<String>(2);
            BytesReference source = null;
            Boolean queryCache = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!"types".equals(currentFieldName)) continue;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        types.add(parser.text());
                    }
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (!"source".equals(currentFieldName)) continue;
                    XContentBuilder builder = XContentFactory.jsonBuilder().map(parser.mapOrdered());
                    source = builder.bytes();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                    if (!"source".equals(currentFieldName)) continue;
                    source = new BytesArray(parser.binaryValue());
                    continue;
                }
                if (!token.isValue() || !"requestCache".equals(currentFieldName) && !"request_cache".equals(currentFieldName)) continue;
                queryCache = parser.booleanValue();
            }
            entries.add(new Entry(name, types.size() == 0 ? Strings.EMPTY_ARRAY : types.toArray(new String[types.size()]), queryCache, source));
        }
        return new IndexWarmersMetaData(entries.toArray(new Entry[entries.size()]));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Entry entry : this.entries()) {
            IndexWarmersMetaData.toXContent(entry, builder, params);
        }
        return builder;
    }

    public static void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean binary = params.paramAsBoolean("binary", false);
        builder.startObject(entry.name(), XContentBuilder.FieldCaseConversion.NONE);
        builder.field("types", entry.types());
        if (entry.requestCache() != null) {
            builder.field("requestCache", (Object)entry.requestCache());
        }
        builder.field("source");
        if (binary) {
            builder.value(entry.source());
        } else {
            Map<String, Object> mapping;
            try (XContentParser parser = XContentFactory.xContent(entry.source()).createParser(entry.source());){
                mapping = parser.mapOrdered();
            }
            builder.map(mapping);
        }
        builder.endObject();
    }

    @Override
    public IndexMetaData.Custom mergeWith(IndexMetaData.Custom other) {
        IndexWarmersMetaData second = (IndexWarmersMetaData)other;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.addAll(this.entries());
        for (Entry secondEntry : second.entries()) {
            boolean found = false;
            for (Entry firstEntry : this.entries()) {
                if (!firstEntry.name().equals(secondEntry.name())) continue;
                found = true;
                break;
            }
            if (found) continue;
            entries.add(secondEntry);
        }
        return new IndexWarmersMetaData(entries.toArray(new Entry[entries.size()]));
    }

    public static class Entry {
        private final String name;
        private final String[] types;
        private final BytesReference source;
        private final Boolean requestCache;

        public Entry(String name, String[] types, Boolean requestCache, BytesReference source) {
            this.name = name;
            this.types = types == null ? Strings.EMPTY_ARRAY : types;
            this.source = source;
            this.requestCache = requestCache;
        }

        public String name() {
            return this.name;
        }

        public String[] types() {
            return this.types;
        }

        @Nullable
        public BytesReference source() {
            return this.source;
        }

        @Nullable
        public Boolean requestCache() {
            return this.requestCache;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.name.equals(entry.name)) {
                return false;
            }
            if (!Arrays.equals(this.types, entry.types)) {
                return false;
            }
            if (!this.source.equals(entry.source)) {
                return false;
            }
            return Objects.equals(this.requestCache, entry.requestCache);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.types);
            result = 31 * result + this.source.hashCode();
            result = 31 * result + (this.requestCache != null ? this.requestCache.hashCode() : 0);
            return result;
        }
    }
}

