/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.impl.BlockingAwareSessionClient;
import io.atomix.primitive.session.impl.RecoveringSessionClient;
import io.atomix.primitive.session.impl.RetryingSessionClient;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftMetadataClient;
import io.atomix.protocols.raft.impl.DefaultRaftMetadataClient;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.session.RaftSessionClient;
import io.atomix.protocols.raft.session.impl.DefaultRaftSessionClient;
import io.atomix.protocols.raft.session.impl.MemberSelectorManager;
import io.atomix.protocols.raft.session.impl.RaftSessionManager;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class DefaultRaftClient
implements RaftClient {
    private final String clientId;
    private final PartitionId partitionId;
    private final Collection<MemberId> cluster;
    private final RaftClientProtocol protocol;
    private final ThreadContextFactory threadContextFactory;
    private final ThreadContext threadContext;
    private final RaftMetadataClient metadata;
    private final MemberSelectorManager selectorManager = new MemberSelectorManager();
    private final RaftSessionManager sessionManager;

    public DefaultRaftClient(String clientId, PartitionId partitionId, MemberId memberId, Collection<MemberId> cluster, RaftClientProtocol protocol, ThreadContextFactory threadContextFactory) {
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId cannot be null");
        this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId, (Object)"partitionId cannot be null");
        this.cluster = (Collection)Preconditions.checkNotNull(cluster, (Object)"cluster cannot be null");
        this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.threadContextFactory = (ThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
        this.threadContext = threadContextFactory.createContext();
        this.metadata = new DefaultRaftMetadataClient(clientId, protocol, this.selectorManager, threadContextFactory.createContext());
        this.sessionManager = new RaftSessionManager(clientId, memberId, protocol, this.selectorManager, threadContextFactory);
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public long term() {
        return this.sessionManager.term();
    }

    @Override
    public MemberId leader() {
        return this.sessionManager.leader();
    }

    @Override
    public RaftMetadataClient metadata() {
        return this.metadata;
    }

    @Override
    public synchronized CompletableFuture<RaftClient> connect(Collection<MemberId> cluster) {
        CompletableFuture<RaftClient> future = new CompletableFuture<RaftClient>();
        if (cluster == null || cluster.isEmpty()) {
            cluster = this.cluster;
        }
        if (cluster == null || cluster.isEmpty()) {
            throw new IllegalArgumentException("No cluster specified");
        }
        this.sessionManager.resetConnections(null, cluster);
        this.sessionManager.open().whenCompleteAsync((result, error) -> {
            if (error == null) {
                future.complete(this);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, (Executor)this.threadContext);
        return future;
    }

    @Override
    public RaftSessionClient.Builder sessionBuilder(final String primitiveName, final PrimitiveType primitiveType, final ServiceConfig serviceConfig) {
        return new RaftSessionClient.Builder(){

            public SessionClient build() {
                Supplier<CompletableFuture> proxyFactory = () -> CompletableFuture.completedFuture(new DefaultRaftSessionClient(primitiveName, primitiveType, serviceConfig, DefaultRaftClient.this.partitionId, DefaultRaftClient.this.protocol, DefaultRaftClient.this.selectorManager, DefaultRaftClient.this.sessionManager, this.readConsistency, this.communicationStrategy, DefaultRaftClient.this.threadContextFactory.createContext(), this.minTimeout, this.maxTimeout));
                ThreadContext context = DefaultRaftClient.this.threadContextFactory.createContext();
                Object proxy = this.recoveryStrategy == Recovery.RECOVER ? new RecoveringSessionClient(DefaultRaftClient.this.clientId, DefaultRaftClient.this.partitionId, primitiveName, primitiveType, proxyFactory, context) : (SessionClient)proxyFactory.get().join();
                if (this.maxRetries > 0) {
                    proxy = new RetryingSessionClient(proxy, (Scheduler)context, this.maxRetries, this.retryDelay);
                }
                return new BlockingAwareSessionClient(proxy, context);
            }
        };
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return this.sessionManager.close().thenRunAsync(() -> ((ThreadContextFactory)this.threadContextFactory).close());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.clientId).toString();
    }

    public static class Builder
    extends RaftClient.Builder {
        public Builder(Collection<MemberId> cluster) {
            super(cluster);
        }

        public RaftClient build() {
            Preconditions.checkNotNull((Object)this.memberId, (Object)"memberId cannot be null");
            ContextualLogger log = ContextualLoggerFactory.getLogger(DefaultRaftClient.class, (LoggerContext)LoggerContext.builder(RaftClient.class).addValue((Object)this.clientId).build());
            ThreadContextFactory threadContextFactory = this.threadModel.factory("raft-client-" + this.clientId + "-%d", this.threadPoolSize, (Logger)log);
            return new DefaultRaftClient(this.clientId, this.partitionId, this.memberId, this.cluster, this.protocol, threadContextFactory);
        }
    }
}

