/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.partition.impl.RaftMessageContext;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.utils.serializer.Serializer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class RaftClientCommunicator
implements RaftClientProtocol {
    private final RaftMessageContext context;
    private final Serializer serializer;
    private final ClusterCommunicationService clusterCommunicator;

    public RaftClientCommunicator(Serializer serializer, ClusterCommunicationService clusterCommunicator) {
        this(null, serializer, clusterCommunicator);
    }

    public RaftClientCommunicator(String prefix, Serializer serializer, ClusterCommunicationService clusterCommunicator) {
        this.context = new RaftMessageContext(prefix);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.clusterCommunicator = (ClusterCommunicationService)Preconditions.checkNotNull((Object)clusterCommunicator, (Object)"clusterCommunicator cannot be null");
    }

    private <T, U> CompletableFuture<U> sendAndReceive(String subject, T request, MemberId memberId) {
        return this.clusterCommunicator.send(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), memberId);
    }

    @Override
    public CompletableFuture<OpenSessionResponse> openSession(MemberId memberId, OpenSessionRequest request) {
        return this.sendAndReceive(this.context.openSessionSubject, request, memberId);
    }

    @Override
    public CompletableFuture<CloseSessionResponse> closeSession(MemberId memberId, CloseSessionRequest request) {
        return this.sendAndReceive(this.context.closeSessionSubject, request, memberId);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> keepAlive(MemberId memberId, KeepAliveRequest request) {
        return this.sendAndReceive(this.context.keepAliveSubject, request, memberId);
    }

    @Override
    public CompletableFuture<QueryResponse> query(MemberId memberId, QueryRequest request) {
        return this.sendAndReceive(this.context.querySubject, request, memberId);
    }

    @Override
    public CompletableFuture<CommandResponse> command(MemberId memberId, CommandRequest request) {
        return this.sendAndReceive(this.context.commandSubject, request, memberId);
    }

    @Override
    public CompletableFuture<MetadataResponse> metadata(MemberId memberId, MetadataRequest request) {
        return this.sendAndReceive(this.context.metadataSubject, request, memberId);
    }

    @Override
    public void registerHeartbeatHandler(Function<HeartbeatRequest, CompletableFuture<HeartbeatResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.heartbeatSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterHeartbeatHandler() {
        this.clusterCommunicator.unsubscribe(this.context.heartbeatSubject);
    }

    @Override
    public void reset(Set<MemberId> members, ResetRequest request) {
        this.clusterCommunicator.multicast(this.context.resetSubject(request.session()), (Object)request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), members);
    }

    @Override
    public void registerPublishListener(SessionId sessionId, Consumer<PublishRequest> listener, Executor executor) {
        this.clusterCommunicator.subscribe(this.context.publishSubject((Long)sessionId.id()), arg_0 -> ((Serializer)this.serializer).decode(arg_0), listener, executor);
    }

    @Override
    public void unregisterPublishListener(SessionId sessionId) {
        this.clusterCommunicator.unsubscribe(this.context.publishSubject((Long)sessionId.id()));
    }
}

