/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.protocol.AbstractRaftResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import java.util.Objects;

public class OpenSessionResponse
extends AbstractRaftResponse {
    protected final long session;
    protected final long timeout;

    public static Builder builder() {
        return new Builder();
    }

    public OpenSessionResponse(RaftResponse.Status status, RaftError error, long session, long timeout) {
        super(status, error);
        this.session = session;
        this.timeout = timeout;
    }

    public long session() {
        return this.session;
    }

    public long timeout() {
        return this.timeout;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.error, this.status, this.session, this.timeout});
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OpenSessionResponse) {
            OpenSessionResponse response = (OpenSessionResponse)object;
            return response.status == this.status && Objects.equals(response.error, this.error) && response.session == this.session && response.timeout == this.timeout;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("session", this.session).add("timeout", this.timeout).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
    }

    public static class Builder
    extends AbstractRaftResponse.Builder<Builder, OpenSessionResponse> {
        private long session;
        private long timeout;

        public Builder withSession(long session) {
            Preconditions.checkArgument((session > 0L ? 1 : 0) != 0, (Object)"session must be positive");
            this.session = session;
            return this;
        }

        public Builder withTimeout(long timeout) {
            Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
            this.timeout = timeout;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkArgument((this.session > 0L ? 1 : 0) != 0, (Object)"session must be positive");
                Preconditions.checkArgument((this.timeout > 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
            }
        }

        public OpenSessionResponse build() {
            this.validate();
            return new OpenSessionResponse(this.status, this.error, this.session, this.timeout);
        }
    }
}

