/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.ValidationContext;
import org.apache.jena.ext.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.SchemaDateTimeException;

public class YearDV
extends AbstractDateTimeDV {
    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gYear"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str2) throws SchemaDateTimeException {
        int sign;
        int length;
        AbstractDateTimeDV.DateTimeData date2 = new AbstractDateTimeDV.DateTimeData(str2, this);
        int len = str2.length();
        int start = 0;
        if (str2.charAt(0) == '-') {
            start = 1;
        }
        if ((length = ((sign = this.findUTCSign(str2, start, len)) == -1 ? len : sign) - start) < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (length > 4 && str2.charAt(start) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        if (sign == -1) {
            date2.year = this.parseIntYear(str2, len);
        } else {
            date2.year = this.parseIntYear(str2, sign);
            this.getTimeZone(str2, date2, sign, len);
        }
        date2.month = 1;
        date2.day = 1;
        this.validateDateTime(date2);
        this.saveUnnormalized(date2);
        if (date2.utc != 0 && date2.utc != 90) {
            this.normalize(date2);
        }
        date2.position = 0;
        return date2;
    }

    @Override
    protected String dateToString(AbstractDateTimeDV.DateTimeData date2) {
        StringBuffer message = new StringBuffer(5);
        this.append(message, date2.year, 4);
        this.append(message, (char)date2.utc, 0);
        return message.toString();
    }

    @Override
    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData date2) {
        return datatypeFactory.newXMLGregorianCalendar(date2.unNormYear, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, date2.hasTimeZone() ? date2.timezoneHr * 60 + date2.timezoneMin : Integer.MIN_VALUE);
    }
}

