/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import org.apache.http.client.HttpClient;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetAccessor;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.web.DatasetAdapter;
import org.apache.jena.web.DatasetGraphAccessor;
import org.apache.jena.web.DatasetGraphAccessorBasic;
import org.apache.jena.web.DatasetGraphAccessorHTTP;

public class DatasetAccessorFactory {
    public static DatasetAccessor createHTTP(String serviceURI) {
        return DatasetAccessorFactory.adapt(new DatasetGraphAccessorHTTP(serviceURI));
    }

    public static DatasetAccessor createHTTP(String serviceURI, HttpClient client) {
        return DatasetAccessorFactory.adapt(new DatasetGraphAccessorHTTP(serviceURI, client));
    }

    public static DatasetAccessor create(DatasetGraph dataset) {
        return DatasetAccessorFactory.adapt(new DatasetGraphAccessorBasic(dataset));
    }

    public static DatasetAccessor create(Dataset dataset) {
        return DatasetAccessorFactory.adapt(new DatasetGraphAccessorBasic(dataset.asDatasetGraph()));
    }

    public static DatasetGraphAccessor make(DatasetGraph dataset) {
        return new DatasetGraphAccessorBasic(dataset);
    }

    private static DatasetAccessor adapt(DatasetGraphAccessor dgu) {
        return new DatasetAdapter(dgu);
    }
}

