/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.checker;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.riot.checker.NodeChecker;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;

public class CheckerIRI
implements NodeChecker {
    private boolean allowRelativeIRIs = false;
    private ErrorHandler handler;
    private IRIFactory iriFactory;
    private final Cache<Node, IRI> cache = CacheFactory.createSimpleCache(5000);

    public CheckerIRI() {
        this(ErrorHandlerFactory.getDefaultErrorHandler(), IRIResolver.iriFactory());
    }

    public CheckerIRI(ErrorHandler handler, IRIFactory iriFactory) {
        this.handler = handler;
        this.iriFactory = iriFactory;
    }

    @Override
    public boolean check(Node node, long line, long col) {
        return node.isURI() && this.checkURI(node, line, col);
    }

    public final boolean checkURI(Node node, long line, long col) {
        if (this.cache != null && this.cache.containsKey(node)) {
            return true;
        }
        IRI iri = this.iriFactory.create(node.getURI());
        boolean b = this.checkIRI(iri, line, col);
        if (this.cache != null && b) {
            this.cache.put(node, iri);
        }
        return b;
    }

    public final boolean checkIRI(IRI iri, long line, long col) {
        CheckerIRI.iriViolations(iri, this.handler, this.allowRelativeIRIs, true, line, col);
        return !iri.hasViolation(true);
    }

    public static void iriViolations(IRI iri, ErrorHandler errorHandler) {
        CheckerIRI.iriViolations(iri, errorHandler, -1L, -1L);
    }

    public static void iriViolations(IRI iri, ErrorHandler errorHandler, long line, long col) {
        CheckerIRI.iriViolations(iri, errorHandler, false, true, line, col);
    }

    private static void iriViolations(IRI iri, ErrorHandler errorHandler, boolean allowRelativeIRIs) {
        CheckerIRI.iriViolations(iri, errorHandler, allowRelativeIRIs, -1L, -1L);
    }

    private static void iriViolations(IRI iri, ErrorHandler errorHandler, boolean allowRelativeIRIs, long line, long col) {
        CheckerIRI.iriViolations(iri, errorHandler, allowRelativeIRIs, true, line, col);
    }

    public static void iriViolations(IRI iri, ErrorHandler errorHandler, boolean allowRelativeIRIs, boolean includeIRIwarnings, long line, long col) {
        if (!allowRelativeIRIs && iri.isRelative()) {
            errorHandler.error("Relative IRI: " + iri, line, col);
        }
        if (iri.hasViolation(includeIRIwarnings)) {
            Iterator<Violation> iter = iri.violations(includeIRIwarnings);
            boolean errorSeen = false;
            boolean warningSeen = false;
            Violation vError = null;
            Violation vWarning = null;
            Object xvSub = null;
            while (iter.hasNext()) {
                Violation v = iter.next();
                int code = v.getViolationCode();
                boolean isError = v.isError();
                if (code == 11 || code == 1 || code == 61) continue;
                if (isError) {
                    errorSeen = true;
                    if (vError == null) {
                        vError = v;
                    }
                } else {
                    warningSeen = true;
                    if (vWarning == null) {
                        vWarning = v;
                    }
                }
                String msg = v.getShortMessage();
                String iriStr = iri.toString();
                if (isError) {
                    errorHandler.warning("Bad IRI: " + msg, line, col);
                    continue;
                }
                errorHandler.warning("Not advised IRI: " + msg, line, col);
            }
        }
    }
}

