/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReader;
import org.apache.jena.riot.resultset.ResultSetReaderFactory;
import org.apache.jena.riot.resultset.rw.ResultSetReaderJSON;
import org.apache.jena.riot.resultset.rw.ResultSetReaderThrift;
import org.apache.jena.riot.resultset.rw.ResultSetReaderXML;
import org.apache.jena.riot.thrift.BinRDF;
import org.apache.jena.sparql.resultset.CSVInput;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.resultset.TSVInput;
import org.apache.jena.sparql.util.Context;

public class ResultSetReaderRegistry {
    private static Map<Lang, ResultSetReaderFactory> registry = new HashMap<Lang, ResultSetReaderFactory>();
    private static boolean initialized = false;
    private static ResultSetReader readerCSV = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context) {
            return CSVInput.fromCSV(in);
        }

        @Override
        public ResultSet read(Reader in, Context context) {
            throw new NotImplemented("Reader");
        }

        @Override
        public SPARQLResult readAny(InputStream in, Context context) {
            return new SPARQLResult(this.read(in, context));
        }
    };
    private static ResultSetReader readerTSV = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context) {
            return TSVInput.fromTSV(in);
        }

        @Override
        public ResultSet read(Reader in, Context context) {
            throw new NotImplemented("Reader");
        }

        @Override
        public SPARQLResult readAny(InputStream in, Context context) {
            return new SPARQLResult(this.read(in, context));
        }
    };
    private static ResultSetReader readerNo = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context) {
            return null;
        }

        @Override
        public ResultSet read(Reader in, Context context) {
            return null;
        }

        @Override
        public SPARQLResult readAny(InputStream in, Context context) {
            return null;
        }
    };

    public static ResultSetReaderFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static void register(Lang lang, ResultSetReaderFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static boolean isRegistered(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.containsKey(lang);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ResultSetReaderFactoryStd factory = new ResultSetReaderFactoryStd();
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetXML, ResultSetReaderXML.factory);
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetJSON, ResultSetReaderJSON.factory);
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetThrift, ResultSetReaderThrift.factory);
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetCSV, factory);
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetTSV, factory);
    }

    private static class ResultSetReaderThriftFactory
    implements ResultSetReaderFactory {
        private ResultSetReaderThriftFactory() {
        }

        @Override
        public ResultSetReader create(Lang lang) {
            return new ResultSetReader(){

                @Override
                public ResultSet read(InputStream in, Context context) {
                    return BinRDF.readResultSet(in);
                }

                @Override
                public ResultSet read(Reader in, Context context) {
                    throw new NotImplemented("Reading binary data from a java.io.Reader is not possible");
                }

                @Override
                public SPARQLResult readAny(InputStream in, Context context) {
                    return new SPARQLResult(this.read(in, context));
                }
            };
        }
    }

    private static class ResultSetReaderFactoryStd
    implements ResultSetReaderFactory {
        private ResultSetReaderFactoryStd() {
        }

        @Override
        public ResultSetReader create(Lang lang) {
            if ((lang = Objects.requireNonNull(lang, "Language must not be null")).equals(ResultSetLang.SPARQLResultSetCSV)) {
                return readerCSV;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetTSV)) {
                return readerTSV;
            }
            throw new RiotException("Lang not registered (ResultSet reader)");
        }
    }
}

