/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpQuad
extends Op0 {
    private final Quad quad;
    private OpQuadPattern opQuadPattern = null;

    public OpQuad(Quad quad) {
        this.quad = quad;
    }

    public final Quad getQuad() {
        return this.quad;
    }

    public OpQuadPattern asQuadPattern() {
        if (this.opQuadPattern == null) {
            BasicPattern bp = new BasicPattern();
            bp.add(this.getQuad().asTriple());
            this.opQuadPattern = new OpQuadPattern(this.quad.getGraph(), bp);
        }
        return this.opQuadPattern;
    }

    @Override
    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    @Override
    public Op0 copy() {
        return new OpQuad(this.quad);
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpQuad)) {
            return false;
        }
        OpQuad opQuad = (OpQuad)other;
        return Iso.quadIso(this.getQuad(), opQuad.getQuad(), labelMap);
    }

    @Override
    public int hashCode() {
        return 0xBA ^ this.quad.hashCode();
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public String getName() {
        return "triple";
    }

    public boolean equivalent(OpQuadPattern opQuads) {
        QuadPattern quads = opQuads.getPattern();
        if (quads.size() != 1) {
            return false;
        }
        Quad q = quads.get(0);
        return this.quad.equals(q);
    }
}

