/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.ClosureTest;

public class Closure {
    public static Model closure(Statement stmt) {
        return Closure.closure(stmt, new ClosureBNode());
    }

    public static Model closure(Statement statement, ClosureTest test) {
        return Closure.closure(statement, test, GraphFactory.makeJenaDefaultModel());
    }

    public static Model closure(Statement statement, Model model) {
        return Closure.closure(statement, (ClosureTest)new ClosureBNode(), model);
    }

    public static Model closure(Statement statement, ClosureTest test, Model model) {
        ArrayList<Resource> visited = new ArrayList<Resource>();
        Closure.closure(statement, model, visited, test);
        return model;
    }

    public static Model closure(Resource resource, boolean testThisNode) {
        return Closure.closure(resource, (ClosureTest)new ClosureBNode(), testThisNode);
    }

    public static Model closure(Resource resource, ClosureTest test, boolean testThisNode) {
        return Closure.closure(resource, test, testThisNode, GraphFactory.makeJenaDefaultModel());
    }

    public static Model closure(Resource resource, boolean testThisNode, Model results) {
        return Closure.closure(resource, new ClosureBNode(), testThisNode, results);
    }

    public static Model closure(Resource resource, ClosureTest test, boolean testThisNode, Model results) {
        ArrayList<Resource> visited = new ArrayList<Resource>();
        if (!testThisNode) {
            Closure.closureNoTest(resource, results, visited, test);
        } else {
            Closure.closure((RDFNode)resource, results, visited, test);
        }
        return results;
    }

    private static void closure(Statement stmt, Model closureBlob, Collection<Resource> visited, ClosureTest test) {
        if (test.includeStmt(stmt)) {
            closureBlob.add(stmt);
        }
        Closure.closure((RDFNode)stmt.getSubject(), closureBlob, visited, test);
        Closure.closure(stmt.getObject(), closureBlob, visited, test);
    }

    private static void closure(RDFNode n, Model closureBlob, Collection<Resource> visited, ClosureTest test) {
        if (!(n instanceof Resource)) {
            return;
        }
        Resource r = (Resource)n;
        if (visited.contains(r)) {
            return;
        }
        if (!test.traverse(r)) {
            return;
        }
        Closure.closureNoTest(r, closureBlob, visited, test);
    }

    private static void closureNoTest(Resource r, Model closureBlob, Collection<Resource> visited, ClosureTest test) {
        visited.add(r);
        StmtIterator sIter = r.listProperties();
        while (sIter.hasNext()) {
            Statement stmt = sIter.nextStatement();
            Closure.closure(stmt, closureBlob, visited, test);
        }
    }

    private static String dbg_string(Collection<?> s) {
        String tmp = "";
        for (Object value : s) {
            tmp = tmp + " " + value.toString();
        }
        return tmp;
    }

    public static class ClosureReachable
    implements ClosureTest {
        @Override
        public boolean traverse(Resource r) {
            return true;
        }

        @Override
        public boolean includeStmt(Statement s) {
            return true;
        }
    }

    public static class ClosureBNode
    implements ClosureTest {
        @Override
        public boolean traverse(Resource r) {
            return r.isAnon();
        }

        @Override
        public boolean includeStmt(Statement s) {
            return true;
        }
    }
}

