/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.compose;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.DifferenceDatasetGraph;
import org.apache.jena.sparql.util.IntersectionDatasetGraph;
import org.apache.jena.sparql.util.UnionDatasetGraph;
import org.apache.jena.sparql.util.compose.DatasetCollector;

public class DatasetLib {
    public static Dataset union(Dataset d1, Dataset d2, Context c) {
        return DatasetFactory.wrap(new UnionDatasetGraph(d1.asDatasetGraph(), d2.asDatasetGraph(), c));
    }

    public static Dataset union(Dataset d1, Dataset d2) {
        return DatasetLib.union(d1, d2, Context.emptyContext);
    }

    public static Dataset intersection(Dataset d1, Dataset d2, Context c) {
        return DatasetFactory.wrap(new IntersectionDatasetGraph(d1.asDatasetGraph(), d2.asDatasetGraph(), c));
    }

    public static Dataset intersection(Dataset d1, Dataset d2) {
        return DatasetLib.intersection(d1, d2, Context.emptyContext);
    }

    public static Dataset difference(Dataset d1, Dataset d2, Context c) {
        return DatasetFactory.wrap(new DifferenceDatasetGraph(d1.asDatasetGraph(), d2.asDatasetGraph(), c));
    }

    public static Dataset difference(Dataset d1, Dataset d2) {
        return DatasetFactory.wrap(new DifferenceDatasetGraph(d1.asDatasetGraph(), d2.asDatasetGraph(), Context.emptyContext));
    }

    public static Collectors collectors() {
        return Collectors.instance;
    }

    public static class Collectors {
        private static final Collectors instance = new Collectors();

        public DatasetCollector union() {
            return DatasetCollector.union();
        }

        public DatasetCollector intersect() {
            return DatasetCollector.intersect();
        }
    }
}

