/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.update;

import java.io.InputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingUtils;
import org.apache.jena.sparql.lang.UpdateParser;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.sparql.modify.UsingList;
import org.apache.jena.sparql.modify.UsingUpdateSink;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateException;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateProcessorStreaming;
import org.apache.jena.update.UpdateRequest;

public class UpdateAction {
    public static void readExecute(String filename, Model model) {
        UpdateAction.readExecute(filename, UpdateAction.toDatasetGraph(model.getGraph()));
    }

    public static void readExecute(String filename, Graph graph) {
        UpdateAction.readExecute(filename, UpdateAction.toDatasetGraph(graph));
    }

    public static void readExecute(String filename, Dataset dataset) {
        UpdateAction.readExecute(filename, dataset.asDatasetGraph());
    }

    public static void readExecute(String filename, DatasetGraph dataset) {
        UpdateAction.readExecute(filename, dataset, null);
    }

    public static void readExecute(String filename, Dataset dataset, QuerySolution inputBinding) {
        UpdateRequest req = UpdateFactory.read(filename);
        UpdateAction.execute(req, dataset, inputBinding);
    }

    public static void readExecute(String filename, DatasetGraph datasetGraph, Binding inputBinding) {
        UpdateRequest req = UpdateFactory.read(filename);
        UpdateAction.execute$(req, datasetGraph, inputBinding);
    }

    public static void parseExecute(String updateString, Model model) {
        UpdateAction.parseExecute(updateString, model.getGraph());
    }

    public static void parseExecute(String updateString, Graph graph) {
        UpdateAction.parseExecute(updateString, UpdateAction.toDatasetGraph(graph));
    }

    public static void parseExecute(String updateString, Dataset dataset) {
        UpdateAction.parseExecute(updateString, dataset.asDatasetGraph());
    }

    public static void parseExecute(String updateString, DatasetGraph dataset) {
        UpdateRequest req = UpdateFactory.create(updateString);
        UpdateAction.execute(req, dataset);
    }

    public static void parseExecute(String updateString, Dataset dataset, QuerySolution inputBinding) {
        UpdateAction.parseExecute(updateString, dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding));
    }

    public static void parseExecute(String updateString, DatasetGraph dataset, Binding inputBinding) {
        UpdateRequest req = UpdateFactory.create(updateString);
        UpdateAction.execute(req, dataset, inputBinding);
    }

    public static void execute(UpdateRequest request, Model model) {
        UpdateAction.execute(request, model.getGraph());
    }

    public static void execute(UpdateRequest request, Graph graph) {
        UpdateAction.execute(request, UpdateAction.toDatasetGraph(graph));
    }

    public static void execute(UpdateRequest request, Dataset dataset) {
        UpdateAction.execute(request, dataset.asDatasetGraph());
    }

    public static void execute(UpdateRequest request, DatasetGraph dataset) {
        UpdateAction.execute$(request, dataset, null);
    }

    public static void execute(UpdateRequest request, Dataset dataset, QuerySolution inputBinding) {
        UpdateAction.execute(request, dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding));
    }

    public static void execute(UpdateRequest request, DatasetGraph datasetGraph, Binding inputBinding) {
        UpdateAction.execute$(request, datasetGraph, inputBinding);
    }

    private static DatasetGraph toDatasetGraph(Graph graph) {
        return DatasetGraphFactory.create(graph);
    }

    private static void execute$(UpdateRequest request, DatasetGraph datasetGraph, Binding inputBinding) {
        UpdateProcessor uProc = UpdateExecutionFactory.create(request, datasetGraph, inputBinding);
        if (uProc == null) {
            throw new ARQException("No suitable update procesors are registered/able to execute your updates");
        }
        uProc.execute();
    }

    public static void execute(Update update, Model model) {
        UpdateAction.execute(update, model.getGraph());
    }

    public static void execute(Update update, Graph graph) {
        UpdateAction.execute(update, UpdateAction.toDatasetGraph(graph));
    }

    public static void execute(Update update, Dataset dataset) {
        UpdateAction.execute(update, dataset.asDatasetGraph());
    }

    public static void execute(Update update, DatasetGraph dataset) {
        UpdateAction.execute(update, dataset, null);
    }

    public static void execute(Update update, Dataset dataset, QuerySolution inputBinding) {
        UpdateAction.execute(update, dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding));
    }

    public static void execute(Update update, DatasetGraph datasetGraph, Binding inputBinding) {
        UpdateAction.execute$(update, datasetGraph, inputBinding);
    }

    private static void execute$(Update update, DatasetGraph datasetGraph, Binding inputBinding) {
        UpdateRequest request = new UpdateRequest();
        request.add(update);
        UpdateAction.execute$(request, datasetGraph, inputBinding);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, String fileName) {
        UpdateAction.parseExecute(usingList, dataset, fileName, null, Syntax.defaultUpdateSyntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, String fileName, Syntax syntax) {
        UpdateAction.parseExecute(usingList, dataset, fileName, null, syntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, String fileName, String baseURI, Syntax syntax) {
        UpdateAction.parseExecute(usingList, dataset, fileName, (Binding)null, baseURI, syntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, String fileName, QuerySolution inputBinding, String baseURI, Syntax syntax) {
        UpdateAction.parseExecute(usingList, dataset, fileName, BindingUtils.asBinding(inputBinding), baseURI, syntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, String fileName, Binding inputBinding, String baseURI, Syntax syntax) {
        InputStream in = null;
        if (fileName.equals("-")) {
            in = System.in;
        } else {
            in = IO.openFile(fileName);
            if (in == null) {
                throw new UpdateException("File could not be opened: " + fileName);
            }
        }
        UpdateAction.parseExecute(usingList, dataset, in, inputBinding, baseURI, syntax);
        if (in != System.in) {
            IO.close(in);
        }
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input) {
        UpdateAction.parseExecute(usingList, dataset, input, Syntax.defaultUpdateSyntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input, Syntax syntax) {
        UpdateAction.parseExecute(usingList, dataset, input, null, syntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input, String baseURI) {
        UpdateAction.parseExecute(usingList, dataset, input, baseURI, Syntax.defaultUpdateSyntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input, String baseURI, Syntax syntax) {
        UpdateAction.parseExecute(usingList, dataset, input, (Binding)null, baseURI, syntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input, QuerySolution inputBinding, String baseURI, Syntax syntax) {
        UpdateAction.parseExecute(usingList, dataset, input, BindingUtils.asBinding(inputBinding), baseURI, syntax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input, Binding inputBinding, String baseURI, Syntax syntax) {
        UpdateProcessorStreaming uProc = UpdateExecutionFactory.createStreaming(dataset, inputBinding);
        if (uProc == null) {
            throw new ARQException("No suitable update procesors are registered/able to execute your updates");
        }
        uProc.startRequest();
        try (UsingUpdateSink sink = new UsingUpdateSink(uProc.getUpdateSink(), usingList);){
            UpdateParser parser = UpdateFactory.setupParser(sink.getPrologue(), baseURI, syntax);
            parser.parse((UpdateSink)sink, input);
        }
        finally {
            uProc.finishRequest();
        }
    }
}

