/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import org.apache.jena.shared.JenaException;
import org.apache.jena.web.JenaHttpNotFoundException;

public class JenaHttpException
extends JenaException {
    private final int statusCode;
    private final String responseMessage;

    public static JenaHttpException create(int code, String msg) {
        if (code == 404) {
            return new JenaHttpNotFoundException(msg);
        }
        return new JenaHttpException(code, msg);
    }

    protected JenaHttpException(int code, String msg) {
        super(msg);
        this.statusCode = code;
        this.responseMessage = msg;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public String toString() {
        return "HTTP: " + this.statusCode + " " + this.getMessage();
    }
}

