/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketLineIn {
    private static final Logger log = LoggerFactory.getLogger(PacketLineIn.class);
    public static final String END = new StringBuilder(0).toString();
    private final InputStream in;
    private final byte[] lineBuffer;

    public PacketLineIn(InputStream i) {
        this.in = i;
        this.lineBuffer = new byte[1000];
    }

    AckNackResult readACK(MutableObjectId returnedId) throws IOException {
        String line = this.readString();
        if (line.length() == 0) {
            throw new PackProtocolException(JGitText.get().expectedACKNAKFoundEOF);
        }
        if ("NAK".equals(line)) {
            return AckNackResult.NAK;
        }
        if (line.startsWith("ACK ")) {
            returnedId.fromString(line.substring(4, 44));
            if (line.length() == 44) {
                return AckNackResult.ACK;
            }
            String arg = line.substring(44);
            if (arg.equals(" continue")) {
                return AckNackResult.ACK_CONTINUE;
            }
            if (arg.equals(" common")) {
                return AckNackResult.ACK_COMMON;
            }
            if (arg.equals(" ready")) {
                return AckNackResult.ACK_READY;
            }
        }
        if (line.startsWith("ERR ")) {
            throw new PackProtocolException(line.substring(4));
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedACKNAKGot, line));
    }

    public String readString() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            log.debug("git< 0000");
            return END;
        }
        if ((len -= 4) == 0) {
            log.debug("git< ");
            return "";
        }
        byte[] raw = len <= this.lineBuffer.length ? this.lineBuffer : new byte[len];
        IO.readFully(this.in, raw, 0, len);
        if (raw[len - 1] == 10) {
            --len;
        }
        String s = RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
        log.debug("git< " + s);
        return s;
    }

    public String readStringRaw() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            log.debug("git< 0000");
            return END;
        }
        byte[] raw = (len -= 4) <= this.lineBuffer.length ? this.lineBuffer : new byte[len];
        IO.readFully(this.in, raw, 0, len);
        String s = RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
        log.debug("git< " + s);
        return s;
    }

    void discardUntilEnd() throws IOException {
        int n;
        while ((n = this.readLength()) != 0) {
            IO.skipFully(this.in, n - 4);
        }
    }

    int readLength() throws IOException {
        IO.readFully(this.in, this.lineBuffer, 0, 4);
        try {
            int len = RawParseUtils.parseHexInt16(this.lineBuffer, 0);
            if (len != 0 && len < 4) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return len;
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidPacketLineHeader, "" + (char)this.lineBuffer[0] + (char)this.lineBuffer[1] + (char)this.lineBuffer[2] + (char)this.lineBuffer[3]));
        }
    }

    static enum AckNackResult {
        NAK,
        ACK,
        ACK_CONTINUE,
        ACK_COMMON,
        ACK_READY;

    }
}

