/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.authentication.sun;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.kerberos.authentication.KerberosTicketValidation;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.util.Assert;

public class SunJaasKerberosTicketValidator
implements KerberosTicketValidator,
InitializingBean {
    private String servicePrincipal;
    private Resource keyTabLocation;
    private Subject serviceSubject;
    private boolean holdOnToGSSContext;
    private boolean debug = false;
    private static final Log LOG = LogFactory.getLog(SunJaasKerberosTicketValidator.class);

    @Override
    public KerberosTicketValidation validateTicket(byte[] token) {
        try {
            return Subject.doAs(this.serviceSubject, new KerberosValidateAction(token));
        }
        catch (PrivilegedActionException e) {
            throw new BadCredentialsException("Kerberos validation not successful", e);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        String keyTabLocationAsString;
        Assert.notNull(this.servicePrincipal, "servicePrincipal must be specified");
        Assert.notNull(this.keyTabLocation, "keyTab must be specified");
        if (this.keyTabLocation instanceof ClassPathResource) {
            LOG.warn("Your keytab is in the classpath. This file needs special protection and shouldn't be in the classpath. JAAS may also not be able to load this file from classpath.");
        }
        if ((keyTabLocationAsString = this.keyTabLocation.getURL().toExternalForm()).startsWith("file:")) {
            keyTabLocationAsString = keyTabLocationAsString.substring(5);
        }
        LoginConfig loginConfig = new LoginConfig(keyTabLocationAsString, this.servicePrincipal, this.debug);
        HashSet<KerberosPrincipal> princ = new HashSet<KerberosPrincipal>(1);
        princ.add(new KerberosPrincipal(this.servicePrincipal));
        Subject sub = new Subject(false, princ, new HashSet(), new HashSet());
        LoginContext lc = new LoginContext("", sub, null, loginConfig);
        lc.login();
        this.serviceSubject = lc.getSubject();
    }

    public void setServicePrincipal(String servicePrincipal) {
        this.servicePrincipal = servicePrincipal;
    }

    public void setKeyTabLocation(Resource keyTabLocation) {
        this.keyTabLocation = keyTabLocation;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setHoldOnToGSSContext(boolean holdOnToGSSContext) {
        this.holdOnToGSSContext = holdOnToGSSContext;
    }

    private static byte[] tweakJdkRegression(byte[] token) throws GSSException {
        if (token == null || token.length < 48) {
            return token;
        }
        int[] toCheck = new int[]{6, 9, 42, 134, 72, 130, 247, 18, 1, 2, 2, 6, 9, 42, 134, 72, 134, 247, 18, 1, 2, 2};
        for (int i = 0; i < 22; ++i) {
            if ((byte)toCheck[i] == token[i + 24]) continue;
            return token;
        }
        byte[] nt = new byte[token.length];
        System.arraycopy(token, 0, nt, 0, 24);
        System.arraycopy(token, 35, nt, 24, 11);
        System.arraycopy(token, 24, nt, 35, 11);
        System.arraycopy(token, 46, nt, 46, token.length - 24 - 11 - 11);
        return nt;
    }

    private static class LoginConfig
    extends Configuration {
        private String keyTabLocation;
        private String servicePrincipalName;
        private boolean debug;

        public LoginConfig(String keyTabLocation, String servicePrincipalName, boolean debug) {
            this.keyTabLocation = keyTabLocation;
            this.servicePrincipalName = servicePrincipalName;
            this.debug = debug;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("useKeyTab", "true");
            options.put("keyTab", this.keyTabLocation);
            options.put("principal", this.servicePrincipalName);
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            if (this.debug) {
                options.put("debug", "true");
            }
            options.put("isInitiator", "false");
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    private class KerberosValidateAction
    implements PrivilegedExceptionAction<KerberosTicketValidation> {
        byte[] kerberosTicket;

        public KerberosValidateAction(byte[] kerberosTicket) {
            this.kerberosTicket = kerberosTicket;
        }

        @Override
        public KerberosTicketValidation run() throws Exception {
            byte[] responseToken = new byte[]{};
            GSSName gssName = null;
            GSSContext context = GSSManager.getInstance().createContext((GSSCredential)null);
            boolean first = true;
            while (!context.isEstablished()) {
                if (first) {
                    this.kerberosTicket = SunJaasKerberosTicketValidator.tweakJdkRegression(this.kerberosTicket);
                }
                responseToken = context.acceptSecContext(this.kerberosTicket, 0, this.kerberosTicket.length);
                gssName = context.getSrcName();
                if (gssName == null) {
                    throw new BadCredentialsException("GSSContext name of the context initiator is null");
                }
                first = false;
            }
            if (!SunJaasKerberosTicketValidator.this.holdOnToGSSContext) {
                context.dispose();
            }
            return new KerberosTicketValidation(gssName.toString(), SunJaasKerberosTicketValidator.this.servicePrincipal, responseToken, context);
        }
    }
}

