/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.Dependency;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.ConfInterpreter;
import org.apache.zeppelin.interpreter.DefaultInterpreterProperty;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterInfo;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterProperty;
import org.apache.zeppelin.interpreter.InterpreterRunner;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.RemoteInterpreterEventServer;
import org.apache.zeppelin.interpreter.SessionConfInterpreter;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.InterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.NullRecoveryStorage;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.plugin.PluginManager;
import org.apache.zeppelin.util.IdHashes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterSetting {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterSetting.class);
    private static final String SHARED_PROCESS = "shared_process";
    private static final String SHARED_SESSION = "shared_session";
    private static final Map<String, Object> DEFAULT_EDITOR = ImmutableMap.of((Object)"language", (Object)"text", (Object)"editOnDblClick", (Object)false);
    public static String PARAGRAPH_CONFIG_RUNONSELECTIONCHANGE = "runOnSelectionChange";
    public static String PARAGRAPH_CONFIG_TITLE = "title";
    public static String PARAGRAPH_CONFIG_CHECK_EMTPY = "checkEmpty";
    private String id;
    private String name;
    private String group;
    private Object properties = new Properties();
    private Status status = Status.READY;
    private String errorReason;
    @SerializedName(value="interpreterGroup")
    private List<InterpreterInfo> interpreterInfos;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private InterpreterOption option = new InterpreterOption();
    @SerializedName(value="runner")
    private InterpreterRunner interpreterRunner;
    private transient InterpreterSettingManager interpreterSettingManager;
    private transient String interpreterDir;
    private final transient Map<String, ManagedInterpreterGroup> interpreterGroups = new ConcurrentHashMap<String, ManagedInterpreterGroup>();
    private final transient ReentrantReadWriteLock.ReadLock interpreterGroupReadLock;
    private final transient ReentrantReadWriteLock.WriteLock interpreterGroupWriteLock;
    private transient AngularObjectRegistryListener angularObjectRegistryListener;
    private transient RemoteInterpreterProcessListener remoteInterpreterProcessListener;
    private transient ApplicationEventListener appEventListener;
    private transient DependencyResolver dependencyResolver;
    private transient ZeppelinConfiguration conf = ZeppelinConfiguration.create();
    private transient RecoveryStorage recoveryStorage;
    private transient RemoteInterpreterEventServer interpreterEventServer;
    public static final String CLUSTER_INTERPRETER_LAUNCHER_NAME = "ClusterInterpreterLauncher";

    public InterpreterSetting() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.id = IdHashes.generateId();
        this.interpreterGroupReadLock = lock.readLock();
        this.interpreterGroupWriteLock = lock.writeLock();
    }

    void postProcessing() {
        this.id = this.name;
        if (this.recoveryStorage == null) {
            try {
                this.recoveryStorage = new NullRecoveryStorage(this.conf, this.interpreterSettingManager);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public InterpreterSetting(InterpreterSetting o) {
        this();
        this.id = o.name;
        this.name = o.name;
        this.group = o.group;
        this.properties = InterpreterSetting.convertInterpreterProperties(o.getProperties());
        this.interpreterInfos = new ArrayList<InterpreterInfo>(o.getInterpreterInfos());
        this.option = InterpreterOption.fromInterpreterOption((InterpreterOption)o.getOption());
        this.dependencies = new ArrayList<Dependency>(o.getDependencies());
        this.interpreterDir = o.getInterpreterDir();
        this.interpreterRunner = o.getInterpreterRunner();
        this.conf = o.getConf();
    }

    private InterpreterLauncher createLauncher(Properties properties) throws IOException {
        return PluginManager.get().loadInterpreterLauncher(this.getLauncherPlugin(properties), this.recoveryStorage);
    }

    public AngularObjectRegistryListener getAngularObjectRegistryListener() {
        return this.angularObjectRegistryListener;
    }

    public RemoteInterpreterProcessListener getRemoteInterpreterProcessListener() {
        return this.remoteInterpreterProcessListener;
    }

    public ApplicationEventListener getAppEventListener() {
        return this.appEventListener;
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public InterpreterSettingManager getInterpreterSettingManager() {
        return this.interpreterSettingManager;
    }

    public InterpreterSetting setAngularObjectRegistryListener(AngularObjectRegistryListener angularObjectRegistryListener) {
        this.angularObjectRegistryListener = angularObjectRegistryListener;
        return this;
    }

    public InterpreterSetting setAppEventListener(ApplicationEventListener appEventListener) {
        this.appEventListener = appEventListener;
        return this;
    }

    public InterpreterSetting setRemoteInterpreterProcessListener(RemoteInterpreterProcessListener remoteInterpreterProcessListener) {
        this.remoteInterpreterProcessListener = remoteInterpreterProcessListener;
        return this;
    }

    public InterpreterSetting setDependencyResolver(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
        return this;
    }

    public InterpreterSetting setInterpreterSettingManager(InterpreterSettingManager interpreterSettingManager) {
        this.interpreterSettingManager = interpreterSettingManager;
        return this;
    }

    public InterpreterSetting setRecoveryStorage(RecoveryStorage recoveryStorage) {
        this.recoveryStorage = recoveryStorage;
        return this;
    }

    public InterpreterSetting setInterpreterEventServer(RemoteInterpreterEventServer interpreterEventServer) {
        this.interpreterEventServer = interpreterEventServer;
        return this;
    }

    public InterpreterInfo getInterpreterInfo(String name) {
        for (InterpreterInfo info : this.interpreterInfos) {
            if (!StringUtils.equals((CharSequence)info.getName(), (CharSequence)name)) continue;
            return info;
        }
        return null;
    }

    public Map<String, Object> getConfig(String className) {
        Map<String, Object> configSetting = new HashMap<String, Object>();
        for (InterpreterInfo intpInfo : this.interpreterInfos) {
            if (!className.equals(intpInfo.getClassName())) continue;
            if (intpInfo.getConfig() == null) break;
            configSetting = intpInfo.getConfig();
            break;
        }
        return configSetting;
    }

    public RecoveryStorage getRecoveryStorage() {
        return this.recoveryStorage;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    private String getInterpreterGroupId(ExecutionContext executionContext) {
        if (!StringUtils.isBlank((CharSequence)executionContext.getInterpreterGroupId())) {
            return executionContext.getInterpreterGroupId();
        }
        if (executionContext.isInIsolatedMode()) {
            return this.name + "-isolated-" + executionContext.getNoteId() + "-" + executionContext.getStartTime();
        }
        ArrayList<String> keys = new ArrayList<String>();
        if (this.option.isExistingProcess) {
            keys.add("existing_process");
        } else if (this.getOption().isIsolated()) {
            if (this.option.perUserIsolated()) {
                keys.add(executionContext.getUser());
            }
            if (this.option.perNoteIsolated()) {
                keys.add(executionContext.getNoteId());
            }
        } else {
            keys.add(SHARED_PROCESS);
        }
        return this.id + "-" + StringUtils.join(keys, (String)"-");
    }

    private String getInterpreterSessionId(ExecutionContext executionContext) {
        String key = this.option.isExistingProcess() ? "existing_process" : (this.option.perNoteScoped() && this.option.perUserScoped() ? executionContext.getUser() + ":" + executionContext.getNoteId() : (this.option.perUserScoped() ? executionContext.getUser() : (this.option.perNoteScoped() ? executionContext.getNoteId() : SHARED_SESSION)));
        return key;
    }

    public ManagedInterpreterGroup getOrCreateInterpreterGroup(String user, String noteId) {
        return this.getOrCreateInterpreterGroup(this.getExecutionContext(user, noteId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedInterpreterGroup getOrCreateInterpreterGroup(ExecutionContext executionContext) {
        String groupId = this.getInterpreterGroupId(executionContext);
        try {
            this.interpreterGroupWriteLock.lock();
            if (!this.interpreterGroups.containsKey(groupId)) {
                LOGGER.info("Create InterpreterGroup with groupId: {} for {}", (Object)groupId, (Object)executionContext);
                ManagedInterpreterGroup intpGroup = this.createInterpreterGroup(groupId);
                this.interpreterGroups.put(groupId, intpGroup);
            }
            ManagedInterpreterGroup managedInterpreterGroup = this.interpreterGroups.get(groupId);
            return managedInterpreterGroup;
        }
        finally {
            this.interpreterGroupWriteLock.unlock();
        }
    }

    void removeInterpreterGroup(String groupId) {
        try {
            this.interpreterGroupWriteLock.lock();
            this.interpreterGroups.remove(groupId);
        }
        finally {
            this.interpreterGroupWriteLock.unlock();
        }
    }

    public ManagedInterpreterGroup getInterpreterGroup(String user, String noteId) {
        return this.getInterpreterGroup(this.getExecutionContext(user, noteId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedInterpreterGroup getInterpreterGroup(ExecutionContext executionContext) {
        String groupId = this.getInterpreterGroupId(executionContext);
        try {
            this.interpreterGroupReadLock.lock();
            ManagedInterpreterGroup managedInterpreterGroup = this.interpreterGroups.get(groupId);
            return managedInterpreterGroup;
        }
        finally {
            this.interpreterGroupReadLock.unlock();
        }
    }

    ManagedInterpreterGroup getInterpreterGroup(String groupId) {
        return this.interpreterGroups.get(groupId);
    }

    public List<ManagedInterpreterGroup> getAllInterpreterGroups() {
        try {
            this.interpreterGroupReadLock.lock();
            ArrayList<ManagedInterpreterGroup> arrayList = new ArrayList<ManagedInterpreterGroup>(this.interpreterGroups.values());
            return arrayList;
        }
        finally {
            this.interpreterGroupReadLock.unlock();
        }
    }

    Map<String, Object> getEditorFromSettingByClassName(String className) {
        for (InterpreterInfo intpInfo : this.interpreterInfos) {
            if (!className.equals(intpInfo.getClassName())) continue;
            if (intpInfo.getEditor() == null) break;
            return intpInfo.getEditor();
        }
        return DEFAULT_EDITOR;
    }

    public void closeInterpreters(String user, String noteId) {
        this.closeInterpreters(this.getExecutionContext(user, noteId));
    }

    public void closeInterpreters(String interpreterGroupId) {
        ExecutionContext executionContext = new ExecutionContext();
        executionContext.setInterpreterGroupId(interpreterGroupId);
        this.closeInterpreters(executionContext);
    }

    public void closeInterpreters(ExecutionContext executionContext) {
        ManagedInterpreterGroup interpreterGroup = this.getInterpreterGroup(executionContext);
        if (interpreterGroup != null) {
            String sessionId = this.getInterpreterSessionId(executionContext);
            interpreterGroup.close(sessionId);
            if (interpreterGroup.isEmpty()) {
                this.interpreterGroups.remove(interpreterGroup.getId());
            }
        }
    }

    public void close() {
        LOGGER.info("Close InterpreterSetting: {}", (Object)this.name);
        List closeThreads = this.interpreterGroups.values().stream().map(g -> new Thread(g::close, this.name + "-close")).peek(t -> t.setUncaughtExceptionHandler((th, e) -> LOGGER.error("InterpreterSetting close error", e))).peek(Thread::start).collect(Collectors.toList());
        this.interpreterGroups.clear();
        for (Thread t2 : closeThreads) {
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                LOGGER.error("Can't wait InterpreterSetting close threads", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public void setProperties(Object object) {
        this.properties = object;
    }

    public void fillPropertyDescription(Object propertiesInTemplate) {
        if (propertiesInTemplate instanceof Map) {
            Map propertiesInTemplate2 = (Map)propertiesInTemplate;
            if (this.properties instanceof Map) {
                Map newInterpreterProperties = (Map)this.properties;
                for (Map.Entry entry : newInterpreterProperties.entrySet()) {
                    if (!propertiesInTemplate2.containsKey(entry.getKey())) continue;
                    ((InterpreterProperty)entry.getValue()).setDescription(((DefaultInterpreterProperty)propertiesInTemplate2.get(entry.getKey())).getDescription());
                }
                this.properties = newInterpreterProperties;
            }
        }
    }

    public void sortPropertiesByTemplate(Object propertiesInTemplate) {
        if (propertiesInTemplate instanceof LinkedHashMap) {
            ArrayList sortedKeys = new ArrayList(((LinkedHashMap)propertiesInTemplate).keySet());
            if (this.properties instanceof LinkedHashMap) {
                LinkedHashMap unSortedProperties = (LinkedHashMap)this.properties;
                ArrayList keys = new ArrayList(unSortedProperties.keySet());
                keys.sort((o1, o2) -> {
                    int i1 = sortedKeys.indexOf(o1);
                    int i2 = sortedKeys.indexOf(o2);
                    if (i1 != -1 && i2 != -1) {
                        return i1 - i2;
                    }
                    return i2 - i1;
                });
                LinkedHashMap<String, InterpreterProperty> sortedProperties = new LinkedHashMap<String, InterpreterProperty>();
                for (String key : keys) {
                    sortedProperties.put(key, (InterpreterProperty)unSortedProperties.get(key));
                }
                this.properties = sortedProperties;
            }
        }
    }

    public Object getProperties() {
        return this.properties;
    }

    @VisibleForTesting
    public void setProperty(String name, String value) {
        ((Map)this.properties).put(name, new InterpreterProperty(name, (Object)value));
    }

    public Properties getJavaProperties() {
        Properties jProperties = new Properties();
        Map iProperties = (Map)this.properties;
        for (Map.Entry entry : iProperties.entrySet()) {
            if (((InterpreterProperty)entry.getValue()).getValue() == null || !StringUtils.isNotBlank((CharSequence)((InterpreterProperty)entry.getValue()).getValue().toString())) continue;
            jProperties.setProperty(((String)entry.getKey()).trim(), ((InterpreterProperty)entry.getValue()).getValue().toString().trim());
        }
        if (!jProperties.containsKey("zeppelin.interpreter.output.limit")) {
            jProperties.setProperty("zeppelin.interpreter.output.limit", this.conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_OUTPUT_LIMIT) + "");
        }
        if (!jProperties.containsKey(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECTION_POOL_SIZE.getVarName())) {
            jProperties.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECTION_POOL_SIZE.getVarName(), this.conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECTION_POOL_SIZE) + "");
        }
        String interpreterLocalRepoPath = this.conf.getInterpreterLocalRepoPath();
        jProperties.setProperty("zeppelin.interpreter.localRepo", interpreterLocalRepoPath + "/" + this.id);
        return jProperties;
    }

    public ZeppelinConfiguration getConf() {
        return this.conf;
    }

    public InterpreterSetting setConf(ZeppelinConfiguration conf) {
        this.conf = conf;
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
        if (!this.dependencies.isEmpty()) {
            this.loadInterpreterDependencies();
        } else {
            this.setStatus(Status.READY);
            this.setErrorReason(null);
        }
    }

    public InterpreterOption getOption() {
        return this.option;
    }

    public void setOption(InterpreterOption option) {
        this.option = option;
    }

    public String getInterpreterDir() {
        return this.interpreterDir;
    }

    public void setInterpreterDir(String interpreterDir) {
        this.interpreterDir = interpreterDir;
    }

    public List<InterpreterInfo> getInterpreterInfos() {
        return this.interpreterInfos;
    }

    void appendDependencies(List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            if (this.dependencies.contains(dependency)) continue;
            this.dependencies.add(dependency);
        }
        if (!dependencies.isEmpty()) {
            this.loadInterpreterDependencies();
        }
    }

    void setInterpreterOption(InterpreterOption interpreterOption) {
        this.option = interpreterOption;
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    void setGroup(String group) {
        this.group = group;
    }

    void setName(String name) {
        this.name = name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        LOGGER.info("Set interpreter {} status to {}", (Object)this.name, (Object)status);
        this.status = status;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public void setErrorReason(String errorReason) {
        this.errorReason = errorReason;
    }

    public void setInterpreterInfos(List<InterpreterInfo> interpreterInfos) {
        this.interpreterInfos = interpreterInfos;
    }

    public InterpreterRunner getInterpreterRunner() {
        return this.interpreterRunner;
    }

    public void setInterpreterRunner(InterpreterRunner interpreterRunner) {
        this.interpreterRunner = interpreterRunner;
    }

    public String getLauncherPlugin(Properties properties) {
        if (this.isRunningOnKubernetes()) {
            if (this.group.equals("flink")) {
                return "FlinkInterpreterLauncher";
            }
            return "K8sStandardInterpreterLauncher";
        }
        if (this.isRunningOnCluster()) {
            return CLUSTER_INTERPRETER_LAUNCHER_NAME;
        }
        if (this.isRunningOnDocker()) {
            return "DockerInterpreterLauncher";
        }
        String launcher = properties.getProperty("zeppelin.interpreter.launcher");
        LOGGER.debug("zeppelin.interpreter.launcher: {}", (Object)launcher);
        if (this.group.equals("spark")) {
            return "SparkInterpreterLauncher";
        }
        if (this.group.equals("flink")) {
            if ("yarn".equals(launcher)) {
                return "YarnInterpreterLauncher";
            }
            return "FlinkInterpreterLauncher";
        }
        if ("yarn".equals(launcher)) {
            return "YarnInterpreterLauncher";
        }
        return "StandardInterpreterLauncher";
    }

    private boolean isRunningOnKubernetes() {
        return this.conf.getRunMode() == ZeppelinConfiguration.RUN_MODE.K8S;
    }

    private boolean isRunningOnCluster() {
        return this.conf.isClusterMode();
    }

    private boolean isRunningOnDocker() {
        return this.conf.getRunMode() == ZeppelinConfiguration.RUN_MODE.DOCKER;
    }

    public boolean isUserAuthorized(List<String> userAndRoles) {
        if (!this.option.permissionIsSet()) {
            return true;
        }
        HashSet<String> intersection = new HashSet<String>(userAndRoles);
        intersection.retainAll(this.option.getOwners());
        return !intersection.isEmpty();
    }

    List<Interpreter> createInterpreters(String user, String interpreterGroupId, String sessionId) {
        ArrayList<Interpreter> interpreters = new ArrayList<Interpreter>();
        List<InterpreterInfo> interpreterInfos = this.getInterpreterInfos();
        Properties intpProperties = this.getJavaProperties();
        for (InterpreterInfo info : interpreterInfos) {
            RemoteInterpreter interpreter = new RemoteInterpreter(intpProperties, sessionId, info.getClassName(), user);
            if (info.isDefaultInterpreter()) {
                interpreters.add(0, interpreter);
            } else {
                interpreters.add(interpreter);
            }
            LOGGER.info("Interpreter {} created for user: {}, sessionId: {}", new Object[]{interpreter.getClassName(), user, sessionId});
        }
        if (this.group.equals("livy")) {
            interpreters.add(new SessionConfInterpreter(intpProperties, sessionId, interpreterGroupId, this));
        } else {
            interpreters.add(new ConfInterpreter(intpProperties, sessionId, interpreterGroupId, this));
        }
        return interpreters;
    }

    synchronized RemoteInterpreterProcess createInterpreterProcess(String interpreterGroupId, String userName, Properties properties) throws IOException {
        InterpreterLauncher launcher = this.createLauncher(properties);
        InterpreterLaunchContext launchContext = new InterpreterLaunchContext(properties, this.option, this.interpreterRunner, userName, interpreterGroupId, this.id, this.group, this.name, this.interpreterEventServer.getPort(), this.interpreterEventServer.getHost());
        RemoteInterpreterProcess process = (RemoteInterpreterProcess)launcher.launch(launchContext);
        this.recoveryStorage.onInterpreterClientStart((InterpreterClient)process);
        return process;
    }

    List<Interpreter> getOrCreateSession(String user, String noteId) {
        return this.getOrCreateSession(this.getExecutionContext(user, noteId));
    }

    List<Interpreter> getOrCreateSession(ExecutionContext executionContext) {
        ManagedInterpreterGroup interpreterGroup = this.getOrCreateInterpreterGroup(executionContext);
        Preconditions.checkNotNull((Object)((Object)interpreterGroup), (String)"No InterpreterGroup existed for {}", (Object)executionContext);
        String sessionId = this.getInterpreterSessionId(executionContext);
        return interpreterGroup.getOrCreateSession(executionContext.getUser(), sessionId);
    }

    public Interpreter getDefaultInterpreter(String user, String noteId) {
        return this.getOrCreateSession(this.getExecutionContext(user, noteId)).get(0);
    }

    public Interpreter getDefaultInterpreter(ExecutionContext executionContext) {
        return this.getOrCreateSession(executionContext).get(0);
    }

    public Interpreter getInterpreter(String user, String noteId, String replName) {
        return this.getInterpreter(this.getExecutionContext(user, noteId), replName);
    }

    public Interpreter getInterpreter(ExecutionContext executionContext, String replName) {
        Preconditions.checkNotNull((Object)replName, (Object)"replName should be not null");
        String className = this.getInterpreterClassFromInterpreterSetting(replName);
        if (className == null) {
            return null;
        }
        List<Interpreter> interpreters = this.getOrCreateSession(executionContext);
        for (Interpreter interpreter : interpreters) {
            if (!className.equals(interpreter.getClassName())) continue;
            return interpreter;
        }
        return null;
    }

    private String getInterpreterClassFromInterpreterSetting(String replName) {
        Preconditions.checkNotNull((Object)replName, (Object)"replName should be not null");
        for (InterpreterInfo info : this.interpreterInfos) {
            String infoName = info.getName();
            if (null == info.getName() || !replName.equals(infoName)) continue;
            return info.getClassName();
        }
        if (replName.equals("conf")) {
            if (this.group.equals("livy")) {
                return SessionConfInterpreter.class.getName();
            }
            return ConfInterpreter.class.getName();
        }
        return null;
    }

    private ManagedInterpreterGroup createInterpreterGroup(String groupId) {
        ManagedInterpreterGroup interpreterGroup = new ManagedInterpreterGroup(groupId, this);
        RemoteAngularObjectRegistry angularObjectRegistry = new RemoteAngularObjectRegistry(groupId, this.angularObjectRegistryListener, interpreterGroup);
        interpreterGroup.setAngularObjectRegistry(angularObjectRegistry);
        return interpreterGroup;
    }

    public void setInterpreterGroupProperties(String interpreterGroupId, Properties properties) throws IOException {
        ManagedInterpreterGroup interpreterGroup = this.interpreterGroups.get(interpreterGroupId);
        for (List session : interpreterGroup.sessions.values()) {
            for (Interpreter intp : session) {
                if (!intp.getProperties().equals(properties) && interpreterGroup.getRemoteInterpreterProcess() != null && interpreterGroup.getRemoteInterpreterProcess().isRunning()) {
                    throw new IOException("Can not change interpreter properties when interpreter process has already been launched");
                }
                intp.setProperties(properties);
            }
        }
    }

    private void loadInterpreterDependencies() {
        this.setStatus(Status.DOWNLOADING_DEPENDENCIES);
        this.setErrorReason(null);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    List<Dependency> deps;
                    File localRepoDir = new File(InterpreterSetting.this.conf.getInterpreterLocalRepoPath() + '/' + InterpreterSetting.this.id);
                    if (localRepoDir.exists()) {
                        try {
                            FileUtils.forceDelete((File)localRepoDir);
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.info("A file that does not exist cannot be deleted, nothing to worry", (Throwable)e);
                        }
                    }
                    if ((deps = InterpreterSetting.this.getDependencies()) != null && !deps.isEmpty()) {
                        LOGGER.info("Start to download dependencies for interpreter: {}", (Object)InterpreterSetting.this.name);
                        for (Dependency d : deps) {
                            File destDir = new File(InterpreterSetting.this.conf.getAbsoluteDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_DEP_LOCALREPO));
                            if (d.getExclusions() != null) {
                                InterpreterSetting.this.dependencyResolver.load(d.getGroupArtifactVersion(), (Collection)d.getExclusions(), new File(destDir, InterpreterSetting.this.id));
                                continue;
                            }
                            InterpreterSetting.this.dependencyResolver.load(d.getGroupArtifactVersion(), new File(destDir, InterpreterSetting.this.id));
                        }
                        LOGGER.info("Finish downloading dependencies for interpreter: {}", (Object)InterpreterSetting.this.name);
                    }
                    InterpreterSetting.this.setStatus(Status.READY);
                    InterpreterSetting.this.setErrorReason(null);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Error while downloading repos for interpreter group : %s, go to interpreter setting page click on edit and save it again to make this interpreter work properly. : %s", InterpreterSetting.this.getGroup(), e.getLocalizedMessage()), (Throwable)e);
                    InterpreterSetting.this.setErrorReason(e.getLocalizedMessage());
                    InterpreterSetting.this.setStatus(Status.ERROR);
                }
                try {
                    InterpreterSetting.this.interpreterSettingManager.saveToFile();
                }
                catch (IOException e) {
                    LOGGER.error("Fail to save interpreter.json", (Throwable)e);
                }
            }
        };
        t.start();
    }

    public void convertPermissionsFromUsersToOwners(JsonObject jsonObject) {
        JsonArray users;
        JsonObject option;
        if (jsonObject != null && (option = jsonObject.getAsJsonObject("option")) != null && (users = option.getAsJsonArray("users")) != null) {
            if (this.option.getOwners() == null) {
                this.option.owners = new LinkedList();
            }
            for (JsonElement user : users) {
                this.option.getOwners().add(user.getAsString());
            }
        }
    }

    static Map<String, InterpreterProperty> convertInterpreterProperties(Object properties) {
        if (properties instanceof Map) {
            Map dProperties = (Map)properties;
            LinkedHashMap<String, InterpreterProperty> newProperties = new LinkedHashMap<String, InterpreterProperty>();
            for (Map.Entry dPropertiesEntry : dProperties.entrySet()) {
                String key = (String)dPropertiesEntry.getKey();
                Object value = dPropertiesEntry.getValue();
                if (value instanceof InterpreterProperty) {
                    return (Map)properties;
                }
                if (value instanceof Map) {
                    Map stringMap = (Map)value;
                    InterpreterProperty newProperty = new InterpreterProperty(key, stringMap.get("value"), stringMap.containsKey("type") ? stringMap.get("type").toString() : "string");
                    newProperties.put(newProperty.getName(), newProperty);
                    continue;
                }
                if (value instanceof DefaultInterpreterProperty) {
                    DefaultInterpreterProperty dProperty = (DefaultInterpreterProperty)value;
                    InterpreterProperty property = new InterpreterProperty(key, dProperty.getValue(), dProperty.getType() != null ? dProperty.getType() : "string", dProperty.getDescription());
                    newProperties.put(key, property);
                    continue;
                }
                if (value instanceof String) {
                    InterpreterProperty newProperty = new InterpreterProperty(key, value, "string");
                    newProperties.put(newProperty.getName(), newProperty);
                    continue;
                }
                throw new RuntimeException("Can not convert this type of property: " + value.getClass());
            }
            return newProperties;
        }
        throw new RuntimeException("Can not convert this type: " + (properties != null ? properties.getClass() : "null"));
    }

    public void waitForReady(long timeout) throws InterpreterException {
        long start = System.currentTimeMillis();
        while (this.status != Status.READY) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new InterpreterException((Throwable)e);
            }
            long now = System.currentTimeMillis();
            if (now - start <= timeout) continue;
            throw new InterpreterException("Fail to download dependencies in " + timeout / 1000L + " seconds");
        }
    }

    public void waitForReady() throws InterpreterException {
        this.waitForReady(Long.MAX_VALUE);
    }

    public InterpreterInfo getDefaultInterpreterInfo() throws Exception {
        for (InterpreterInfo interpreterInfo : this.interpreterInfos) {
            if (!interpreterInfo.isDefaultInterpreter()) continue;
            return interpreterInfo;
        }
        if (this.interpreterInfos.size() == 1) {
            return this.interpreterInfos.get(0);
        }
        throw new Exception("No default interpreter info found in interpreter setting: " + this.name);
    }

    public static String toJson(InterpreterSetting intpSetting) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
            jsonWriter.beginObject();
            jsonWriter.name("id");
            jsonWriter.value(intpSetting.getId());
            jsonWriter.name("name");
            jsonWriter.value(intpSetting.getName());
            jsonWriter.name("group");
            jsonWriter.value(intpSetting.getGroup());
            jsonWriter.name("dependencies");
            String jsonDep = gson.toJson(intpSetting.getDependencies(), new TypeToken<List<Dependency>>(){}.getType());
            jsonWriter.value(jsonDep);
            jsonWriter.name("properties");
            String jsonProps = gson.toJson(intpSetting.getProperties(), new TypeToken<Map<String, InterpreterProperty>>(){}.getType());
            jsonWriter.value(jsonProps);
            jsonWriter.name("interpreterOption");
            String jsonOption = gson.toJson((Object)intpSetting.getOption(), new TypeToken<InterpreterOption>(){}.getType());
            jsonWriter.value(jsonOption);
            jsonWriter.name("interpreterGroup");
            String jsonIntpInfos = gson.toJson(intpSetting.getInterpreterInfos(), new TypeToken<List<InterpreterInfo>>(){}.getType());
            jsonWriter.value(jsonIntpInfos);
            jsonWriter.endObject();
            jsonWriter.flush();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return stringWriter.getBuffer().toString();
    }

    public static InterpreterSetting fromJson(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        StringReader stringReader = new StringReader(json);
        JsonReader jsonReader = new JsonReader((Reader)stringReader);
        InterpreterSetting intpSetting = new InterpreterSetting();
        try {
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String tag = jsonReader.nextName();
                if (tag.equals("id")) {
                    String id = jsonReader.nextString();
                    intpSetting.setId(id);
                    continue;
                }
                if (tag.equals("name")) {
                    String name = jsonReader.nextString();
                    intpSetting.setName(name);
                    continue;
                }
                if (tag.equals("group")) {
                    String group = jsonReader.nextString();
                    intpSetting.setGroup(group);
                    continue;
                }
                if (tag.equals("dependencies")) {
                    String strDep = jsonReader.nextString();
                    List dependencies = (List)gson.fromJson(strDep, new TypeToken<List<Dependency>>(){}.getType());
                    intpSetting.setDependencies(dependencies);
                    continue;
                }
                if (tag.equals("properties")) {
                    String strProp = jsonReader.nextString();
                    Map properties = (Map)gson.fromJson(strProp, new TypeToken<Map<String, InterpreterProperty>>(){}.getType());
                    intpSetting.setProperties(properties);
                    continue;
                }
                if (tag.equals("interpreterOption")) {
                    String strOption = jsonReader.nextString();
                    InterpreterOption intpOption = (InterpreterOption)gson.fromJson(strOption, new TypeToken<InterpreterOption>(){}.getType());
                    intpSetting.setOption(intpOption);
                    continue;
                }
                if (tag.equals("interpreterGroup")) {
                    String strIntpInfos = jsonReader.nextString();
                    List intpInfos = (List)gson.fromJson(strIntpInfos, new TypeToken<List<InterpreterInfo>>(){}.getType());
                    intpSetting.setInterpreterInfos(intpInfos);
                    continue;
                }
                LOGGER.error("Error data type!");
            }
            jsonReader.endObject();
            jsonReader.close();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return intpSetting;
    }

    private ExecutionContext getExecutionContext(String user, String noteId) {
        try {
            return this.getInterpreterSettingManager().getNotebook().processNote(noteId, note -> {
                if (note == null) {
                    throw new RuntimeException("No such note: " + noteId);
                }
                ExecutionContext context = note.getExecutionContext();
                context.setUser(user);
                return context;
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to getExecutionContext", e);
        }
    }

    public static enum Status {
        DOWNLOADING_DEPENDENCIES,
        ERROR,
        READY;

    }

    public static class Builder {
        private InterpreterSetting interpreterSetting = new InterpreterSetting();

        public Builder setId(String id) {
            this.interpreterSetting.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.interpreterSetting.name = name;
            return this;
        }

        public Builder setGroup(String group) {
            this.interpreterSetting.group = group;
            return this;
        }

        public Builder setInterpreterInfos(List<InterpreterInfo> interpreterInfos) {
            this.interpreterSetting.interpreterInfos = interpreterInfos;
            return this;
        }

        public Builder setProperties(Object properties) {
            this.interpreterSetting.properties = properties;
            return this;
        }

        public Builder setOption(InterpreterOption option) {
            this.interpreterSetting.option = option;
            return this;
        }

        public Builder setInterpreterDir(String interpreterDir) {
            this.interpreterSetting.interpreterDir = interpreterDir;
            return this;
        }

        public Builder setRunner(InterpreterRunner runner) {
            this.interpreterSetting.interpreterRunner = runner;
            return this;
        }

        public Builder setDependencies(List<Dependency> dependencies) {
            this.interpreterSetting.dependencies = dependencies;
            return this;
        }

        public Builder setConf(ZeppelinConfiguration conf) {
            this.interpreterSetting.conf = conf;
            return this;
        }

        public Builder setDependencyResolver(DependencyResolver dependencyResolver) {
            this.interpreterSetting.dependencyResolver = dependencyResolver;
            return this;
        }

        public Builder setInterpreterRunner(InterpreterRunner runner) {
            this.interpreterSetting.interpreterRunner = runner;
            return this;
        }

        public Builder setIntepreterSettingManager(InterpreterSettingManager interpreterSettingManager) {
            this.interpreterSetting.interpreterSettingManager = interpreterSettingManager;
            return this;
        }

        public Builder setRemoteInterpreterEventServer(RemoteInterpreterEventServer interpreterEventServer) {
            this.interpreterSetting.interpreterEventServer = interpreterEventServer;
            return this;
        }

        public Builder setRemoteInterpreterProcessListener(RemoteInterpreterProcessListener remoteInterpreterProcessListener) {
            this.interpreterSetting.remoteInterpreterProcessListener = remoteInterpreterProcessListener;
            return this;
        }

        public Builder setAngularObjectRegistryListener(AngularObjectRegistryListener angularObjectRegistryListener) {
            this.interpreterSetting.angularObjectRegistryListener = angularObjectRegistryListener;
            return this;
        }

        public Builder setApplicationEventListener(ApplicationEventListener applicationEventListener) {
            this.interpreterSetting.appEventListener = applicationEventListener;
            return this;
        }

        public Builder setRecoveryStorage(RecoveryStorage recoveryStorage) {
            this.interpreterSetting.recoveryStorage = recoveryStorage;
            return this;
        }

        public InterpreterSetting create() {
            this.interpreterSetting.postProcessing();
            return this.interpreterSetting;
        }
    }
}

