/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    private FileUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void atomicWriteToFile(String content, File file, Set<PosixFilePermission> permissions) throws IOException {
        FileSystem defaultFileSystem = FileSystems.getDefault();
        Path destinationFilePath = defaultFileSystem.getPath(file.getCanonicalPath(), new String[0]);
        Path destinationDirectory = destinationFilePath.getParent();
        Files.createDirectories(destinationDirectory, new FileAttribute[0]);
        File tempFile = Files.createTempFile(destinationDirectory, file.getName(), null, new FileAttribute[0]).toFile();
        if (permissions != null && !permissions.isEmpty()) {
            Files.setPosixFilePermissions(tempFile.toPath(), permissions);
        }
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            IOUtils.write((String)content, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iox) {
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
            throw iox;
        }
        try {
            file.getParentFile().mkdirs();
            Files.move(tempFile.toPath(), destinationFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iox) {
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
            throw iox;
        }
    }

    public static void atomicWriteToFile(String content, File file) throws IOException {
        FileUtils.atomicWriteToFile(content, file, null);
    }

    public static String readFromFile(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

