/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.google.common.collect.Iterators;
import com.hubspot.jinjava.util.ForLoop;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public final class ObjectIterator {
    private ObjectIterator() {
    }

    public static ForLoop getLoop(Object obj) {
        if (obj == null) {
            return new ForLoop(Collections.emptyIterator(), 0);
        }
        if (obj instanceof Collection) {
            Collection clt = (Collection)obj;
            return new ForLoop(clt.iterator(), clt.size());
        }
        if (obj.getClass().isArray()) {
            Object[] arr = (Object[])obj;
            return new ForLoop(Iterators.forArray(arr), arr.length);
        }
        if (obj instanceof Map) {
            Collection clt = ((Map)obj).values();
            return new ForLoop(clt.iterator(), clt.size());
        }
        if (obj instanceof Iterable) {
            return new ForLoop(((Iterable)obj).iterator());
        }
        if (obj instanceof Iterator) {
            return new ForLoop((Iterator)obj);
        }
        return new ForLoop(Iterators.singletonIterator(obj), 1);
    }
}

