/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluentImpl;
import java.util.Objects;

public class ResourceQuotaBuilder
extends ResourceQuotaFluentImpl<ResourceQuotaBuilder>
implements VisitableBuilder<ResourceQuota, ResourceQuotaBuilder> {
    ResourceQuotaFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceQuotaBuilder() {
        this(false);
    }

    public ResourceQuotaBuilder(Boolean validationEnabled) {
        this(new ResourceQuota(), validationEnabled);
    }

    public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceQuota(), validationEnabled);
    }

    public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent, ResourceQuota instance) {
        this(fluent, instance, false);
    }

    public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent, ResourceQuota instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ResourceQuotaBuilder(ResourceQuota instance) {
        this(instance, (Boolean)false);
    }

    public ResourceQuotaBuilder(ResourceQuota instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceQuota build() {
        ResourceQuota buildable = new ResourceQuota(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaBuilder that = (ResourceQuotaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

