/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatcherWebSocketListener<T extends HasMetadata>
implements WebSocket.Listener {
    protected static final Logger logger = LoggerFactory.getLogger(WatcherWebSocketListener.class);
    private final Object reconnectLock = new Object();
    protected final AbstractWatchManager<T> manager;

    protected WatcherWebSocketListener(AbstractWatchManager<T> manager) {
        this.manager = manager;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        logger.debug("WebSocket successfully opened");
        this.manager.resetReconnectAttempts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(WebSocket webSocket, Throwable t) {
        if (this.manager.isForceClosed()) {
            logger.debug("Ignoring onFailure for already closed/closing websocket", t);
            return;
        }
        if (this.manager.cannotReconnect()) {
            this.manager.close(new WatcherException("Connection failure", t));
            return;
        }
        Object object = this.reconnectLock;
        synchronized (object) {
            this.manager.scheduleReconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(WebSocket webSocket, String text) {
        Object object = this.reconnectLock;
        synchronized (object) {
            this.manager.onMessage(text);
        }
    }

    @Override
    public void onMessage(WebSocket webSocket, ByteBuffer bytes) {
        this.onMessage(webSocket, StandardCharsets.UTF_8.decode(bytes).toString());
    }

    @Override
    public void onClose(WebSocket webSocket, int code, String reason) {
        logger.debug("WebSocket close received. code: {}, reason: {}", (Object)code, (Object)reason);
        webSocket.sendClose(code, reason);
        this.manager.scheduleReconnect();
    }
}

