/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class ReplaceValueStream {
    private final Map<String, String> valuesMap;

    public static InputStream replaceValues(InputStream is, Map<String, String> valuesMap) throws IOException {
        return new ReplaceValueStream(valuesMap).createInputStream(is);
    }

    private ReplaceValueStream(Map<String, String> valuesMap) {
        this.valuesMap = valuesMap;
    }

    private InputStream createInputStream(InputStream is) throws IOException {
        return new ByteArrayInputStream(Utils.interpolateString(IOHelpers.readFully(is), this.valuesMap).getBytes(StandardCharsets.UTF_8));
    }
}

