/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.barrier.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.core.barrier.DistributedCyclicBarrierType;
import io.atomix.core.barrier.impl.CyclicBarrierResult;
import io.atomix.core.barrier.impl.DistributedCyclicBarrierClient;
import io.atomix.core.barrier.impl.DistributedCyclicBarrierService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class DefaultDistributedCyclicBarrierService
extends AbstractPrimitiveService<DistributedCyclicBarrierClient>
implements DistributedCyclicBarrierService {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(DistributedCyclicBarrierType.instance().namespace()).register(new Class[]{SessionId.class}).build());
    private Set<SessionId> parties = Sets.newHashSet();
    private long barrierId;
    private Map<SessionId, Waiter> waiters = Maps.newLinkedHashMap();
    private boolean broken;

    public DefaultDistributedCyclicBarrierService() {
        super((PrimitiveType)DistributedCyclicBarrierType.instance(), DistributedCyclicBarrierClient.class);
    }

    public Serializer serializer() {
        return SERIALIZER;
    }

    public void backup(BackupOutput output) {
        output.writeObject(this.parties);
        output.writeLong(this.barrierId);
        output.writeBoolean(this.broken);
        output.writeObject(this.waiters.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)((Waiter)entry.getValue()).timeout)).collect(Collectors.toMap(e -> (SessionId)e.getKey(), e -> (Long)e.getValue())));
    }

    public void restore(BackupInput input) {
        this.parties = (Set)input.readObject();
        this.barrierId = input.readLong();
        this.broken = input.readBoolean();
        this.waiters = Maps.newLinkedHashMap();
        Map waiters = (Map)input.readObject();
        waiters.forEach((sessionId, timeout) -> this.waiters.put((SessionId)sessionId, new Waiter((long)timeout, timeout == 0L ? null : this.getScheduler().schedule(Duration.ofMillis(timeout - this.getWallClock().getTime().unixTimestamp()), () -> this.timeout(this.barrierId)))));
    }

    public void onExpire(Session session) {
        this.onClose(session);
    }

    public void onClose(Session session) {
        this.parties.remove(session.sessionId());
        Waiter waiter = this.waiters.remove(session.sessionId());
        if (waiter != null) {
            waiter.cancel();
            if (this.waiters.isEmpty()) {
                this.barrierId = 0L;
                this.broken = false;
            } else if (this.waiters.size() == this.getParties()) {
                AtomicInteger index = new AtomicInteger(this.waiters.size());
                AtomicReference last = new AtomicReference();
                this.waiters.keySet().forEach(sessionId -> {
                    this.getSession((SessionId)sessionId).accept(client -> client.release(this.barrierId, index.decrementAndGet()));
                    last.set(sessionId);
                });
                this.getSession((SessionId)last.get()).accept(client -> client.runAction());
                this.waiters.clear();
                this.barrierId = 0L;
                this.broken = false;
            }
        }
    }

    private void timeout(long barrierId) {
        if (this.barrierId == barrierId && !this.broken) {
            this.broken = true;
            this.parties.forEach(session -> this.getSession((SessionId)session).accept(client -> client.broken(barrierId)));
        }
    }

    @Override
    public void join() {
        this.parties.add(this.getCurrentSession().sessionId());
    }

    @Override
    public CyclicBarrierResult<Long> await(long timeout) {
        if (this.barrierId == 0L) {
            this.barrierId = this.getCurrentIndex();
        }
        if (this.broken) {
            return new CyclicBarrierResult<Long>(CyclicBarrierResult.Status.BROKEN, this.barrierId);
        }
        SessionId sessionId = this.getCurrentSession().sessionId();
        if (timeout > 0L) {
            this.waiters.put(sessionId, new Waiter(this.getWallClock().getTime().unixTimestamp() + timeout, this.getScheduler().schedule(Duration.ofMillis(timeout), () -> this.timeout(this.barrierId))));
        } else {
            this.waiters.put(sessionId, new Waiter(0L, null));
        }
        if (this.waiters.size() == this.getParties()) {
            AtomicInteger index = new AtomicInteger(this.waiters.size());
            this.waiters.keySet().forEach(session -> this.getSession((SessionId)session).accept(client -> client.release(this.barrierId, index.decrementAndGet())));
            this.getCurrentSession().accept(client -> client.runAction());
            this.waiters.clear();
        }
        return new CyclicBarrierResult<Long>(CyclicBarrierResult.Status.OK, this.barrierId);
    }

    @Override
    public int getNumberWaiting() {
        return this.waiters.size();
    }

    @Override
    public int getParties() {
        return this.parties.size();
    }

    @Override
    public boolean isBroken(long barrierId) {
        return (barrierId == 0L || this.barrierId == barrierId) && this.broken;
    }

    @Override
    public void reset(long barrierId) {
        if (this.barrierId > 0L && (barrierId == 0L || this.barrierId == barrierId)) {
            this.waiters.forEach((sessionId, scheduled) -> {
                if (scheduled != null) {
                    scheduled.cancel();
                }
                this.getSession((SessionId)sessionId).accept(client -> client.broken(this.barrierId));
            });
            this.waiters.clear();
            this.broken = false;
            this.barrierId = 0L;
        }
    }

    private static class Waiter {
        private final long timeout;
        private final Scheduled timer;

        Waiter(long timeout, Scheduled timer) {
            this.timeout = timeout;
            this.timer = timer;
        }

        void cancel() {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
    }
}

