/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election.impl;

import io.atomix.core.election.AsyncLeaderElection;
import io.atomix.core.election.LeaderElection;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.LeadershipEventListener;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.Synchronous;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class BlockingLeaderElection<T>
extends Synchronous<AsyncLeaderElection<T>>
implements LeaderElection<T> {
    private final AsyncLeaderElection<T> asyncElector;
    private final long operationTimeoutMillis;

    public BlockingLeaderElection(AsyncLeaderElection<T> asyncElector, long operationTimeoutMillis) {
        super(asyncElector);
        this.asyncElector = asyncElector;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public Leadership<T> run(T identifier) {
        return this.complete(this.asyncElector.run(identifier));
    }

    @Override
    public void withdraw(T identifier) {
        this.complete(this.asyncElector.withdraw(identifier));
    }

    @Override
    public boolean anoint(T identifier) {
        return this.complete(this.asyncElector.anoint(identifier));
    }

    @Override
    public boolean promote(T identifier) {
        return this.complete(this.asyncElector.promote(identifier));
    }

    @Override
    public void evict(T identifier) {
        this.complete(this.asyncElector.evict(identifier));
    }

    @Override
    public Leadership<T> getLeadership() {
        return this.complete(this.asyncElector.getLeadership());
    }

    @Override
    public void addListener(LeadershipEventListener<T> listener) {
        this.complete(this.asyncElector.addListener(listener));
    }

    @Override
    public void removeListener(LeadershipEventListener<T> listener) {
        this.complete(this.asyncElector.removeListener(listener));
    }

    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.asyncElector.addStateChangeListener(listener);
    }

    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.asyncElector.removeStateChangeListener(listener);
    }

    @Override
    public AsyncLeaderElection<T> async() {
        return this.asyncElector;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            throw new PrimitiveException(e.getCause());
        }
    }
}

