/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMapBuilder;
import io.atomix.core.map.AtomicMapConfig;
import io.atomix.core.map.AtomicMapType;
import io.atomix.core.transaction.ManagedTransactionService;
import io.atomix.core.transaction.ParticipantInfo;
import io.atomix.core.transaction.TransactionException;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionService;
import io.atomix.core.transaction.TransactionState;
import io.atomix.core.transaction.Transactional;
import io.atomix.primitive.PrimitiveBuilder;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyCompatibleBuilder;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.EventListener;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.time.Versioned;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTransactionService
implements ManagedTransactionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreTransactionService.class);
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(Namespaces.BASIC).register(new Class[]{MemberId.class}).register(new Class[]{TransactionId.class}).register(new Class[]{TransactionState.class}).register(new Class[]{ParticipantInfo.class}).register(new Class[]{TransactionInfo.class}).build());
    private final PrimitiveManagementService managementService;
    private final MemberId localMemberId;
    private final ClusterMembershipEventListener clusterEventListener = this::onMembershipChange;
    private volatile AsyncAtomicMap<TransactionId, TransactionInfo> transactions;
    private final AtomicBoolean started = new AtomicBoolean();

    public CoreTransactionService(PrimitiveManagementService managementService) {
        this.managementService = (PrimitiveManagementService)Preconditions.checkNotNull((Object)managementService);
        this.localMemberId = managementService.getMembershipService().getLocalMember().id();
    }

    @Override
    public Set<TransactionId> getActiveTransactions() {
        Preconditions.checkState((boolean)this.isRunning());
        return this.transactions.sync().keySet();
    }

    @Override
    public TransactionState getTransactionState(TransactionId transactionId) {
        Preconditions.checkState((boolean)this.isRunning());
        TransactionInfo info = (TransactionInfo)Versioned.valueOrNull(this.transactions.get(transactionId).join());
        return info != null ? info.state : null;
    }

    @Override
    public CompletableFuture<TransactionId> begin() {
        Preconditions.checkState((boolean)this.isRunning());
        TransactionId transactionId = TransactionId.from(UUID.randomUUID().toString());
        TransactionInfo info = new TransactionInfo(this.localMemberId, TransactionState.ACTIVE, (Set<ParticipantInfo>)ImmutableSet.of());
        return this.transactions.put(transactionId, info).thenApply(v -> transactionId);
    }

    @Override
    public CompletableFuture<Void> preparing(TransactionId transactionId, Set<ParticipantInfo> participants) {
        Preconditions.checkState((boolean)this.isRunning());
        return this.transactions.compute(transactionId, (id, info) -> {
            if (info == null) {
                return null;
            }
            if (((TransactionInfo)info).state == TransactionState.ACTIVE && ((TransactionInfo)info).coordinator.equals((Object)this.localMemberId)) {
                return new TransactionInfo(((TransactionInfo)info).coordinator, TransactionState.PREPARING, participants);
            }
            return info;
        }).thenCompose(value -> {
            if (value == null || value.value() == null) {
                return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Unknown transaction " + (Object)((Object)transactionId))));
            }
            if (((TransactionInfo)value.value()).state != TransactionState.PREPARING) {
                return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Concurrent transaction modification " + (Object)((Object)transactionId))));
            }
            if (!((TransactionInfo)value.value()).coordinator.equals((Object)this.localMemberId)) {
                return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Transaction " + (Object)((Object)transactionId) + " recovered by another member")));
            }
            return Futures.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Void> committing(TransactionId transactionId) {
        Preconditions.checkState((boolean)this.isRunning());
        return this.transactions.compute(transactionId, (id, info) -> {
            if (info == null) {
                return null;
            }
            if (((TransactionInfo)info).state == TransactionState.PREPARING && ((TransactionInfo)info).coordinator.equals((Object)this.localMemberId)) {
                return new TransactionInfo(((TransactionInfo)info).coordinator, TransactionState.COMMITTING, ((TransactionInfo)info).participants);
            }
            return info;
        }).thenCompose(value -> {
            if (value == null || value.value() == null) {
                return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Unknown transaction " + (Object)((Object)transactionId))));
            }
            if (((TransactionInfo)value.value()).state != TransactionState.COMMITTING) {
                return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Concurrent transaction modification " + (Object)((Object)transactionId))));
            }
            if (!((TransactionInfo)value.value()).coordinator.equals((Object)this.localMemberId)) {
                return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Transaction " + (Object)((Object)transactionId) + " recovered by another member")));
            }
            return Futures.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Void> aborting(TransactionId transactionId) {
        Preconditions.checkState((boolean)this.isRunning());
        return this.transactions.compute(transactionId, (id, info) -> {
            if (info == null) {
                return null;
            }
            if (((TransactionInfo)info).state == TransactionState.PREPARING && ((TransactionInfo)info).coordinator.equals((Object)this.localMemberId)) {
                return new TransactionInfo(((TransactionInfo)info).coordinator, TransactionState.ROLLING_BACK, ((TransactionInfo)info).participants);
            }
            return info;
        }).thenCompose(value -> {
            if (value == null || value.value() == null) {
                return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Unknown transaction " + (Object)((Object)transactionId))));
            }
            if (((TransactionInfo)value.value()).state != TransactionState.ROLLING_BACK) {
                return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Concurrent transaction modification " + (Object)((Object)transactionId))));
            }
            if (!((TransactionInfo)value.value()).coordinator.equals((Object)this.localMemberId)) {
                return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Transaction " + (Object)((Object)transactionId) + " recovered by another member")));
            }
            return Futures.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Void> complete(TransactionId transactionId) {
        Preconditions.checkState((boolean)this.isRunning());
        return this.transactions.remove(transactionId).thenApply(v -> null);
    }

    private void onMembershipChange(ClusterMembershipEvent event) {
        if (event.type() == ClusterMembershipEvent.Type.MEMBER_REMOVED) {
            this.recoverTransactions(this.transactions.entrySet().iterator(), ((Member)event.subject()).id());
        }
    }

    private void recoverTransactions(AsyncIterator<Map.Entry<TransactionId, Versioned<TransactionInfo>>> iterator, MemberId memberId) {
        iterator.next().thenAccept(entry -> {
            if (((TransactionInfo)((Versioned)entry.getValue()).value()).coordinator.equals((Object)memberId)) {
                this.recoverTransaction((TransactionId)((Object)((Object)entry.getKey())), (TransactionInfo)((Versioned)entry.getValue()).value());
            }
            this.recoverTransactions(iterator, memberId);
        });
    }

    private void recoverTransaction(TransactionId transactionId, TransactionInfo transactionInfo) {
        switch (transactionInfo.state) {
            case PREPARING: {
                this.completePreparingTransaction(transactionId);
                break;
            }
            case COMMITTING: {
                this.completeCommittingTransaction(transactionId);
                break;
            }
            case ROLLING_BACK: {
                this.completeRollingBackTransaction(transactionId);
                break;
            }
        }
    }

    private void completePreparingTransaction(TransactionId transactionId) {
        this.completeTransaction(transactionId, TransactionState.PREPARING, info -> new TransactionInfo(this.localMemberId, TransactionState.ROLLING_BACK, ((TransactionInfo)info).participants), info -> ((TransactionInfo)info).state == TransactionState.ROLLING_BACK, (id, transactional) -> transactional.rollback((TransactionId)((Object)id))).whenComplete((result, error) -> {
            if (error != null) {
                if ((error = Throwables.getRootCause((Throwable)error)) instanceof TransactionException) {
                    LOGGER.warn("Failed to complete transaction", error);
                } else {
                    LOGGER.warn("Failed to roll back transaction " + (Object)((Object)transactionId));
                }
            }
        });
    }

    private void completeCommittingTransaction(TransactionId transactionId) {
        this.completeTransaction(transactionId, TransactionState.COMMITTING, info -> new TransactionInfo(this.localMemberId, TransactionState.COMMITTING, ((TransactionInfo)info).participants), info -> ((TransactionInfo)info).state == TransactionState.COMMITTING && ((TransactionInfo)info).coordinator.equals((Object)this.localMemberId), (id, transactional) -> transactional.commit((TransactionId)((Object)id))).whenComplete((result, error) -> {
            if (error != null) {
                if ((error = Throwables.getRootCause((Throwable)error)) instanceof TransactionException) {
                    LOGGER.warn("Failed to complete transaction", error);
                } else {
                    LOGGER.warn("Failed to commit transaction " + (Object)((Object)transactionId));
                }
            }
        });
    }

    private void completeRollingBackTransaction(TransactionId transactionId) {
        this.completeTransaction(transactionId, TransactionState.ROLLING_BACK, info -> new TransactionInfo(this.localMemberId, TransactionState.ROLLING_BACK, ((TransactionInfo)info).participants), info -> ((TransactionInfo)info).state == TransactionState.ROLLING_BACK && ((TransactionInfo)info).coordinator.equals((Object)this.localMemberId), (id, transactional) -> transactional.rollback((TransactionId)((Object)id))).whenComplete((result, error) -> {
            if (error != null) {
                if ((error = Throwables.getRootCause((Throwable)error)) instanceof TransactionException) {
                    LOGGER.warn("Failed to complete transaction", error);
                } else {
                    LOGGER.warn("Failed to roll back transaction " + (Object)((Object)transactionId));
                }
            }
        });
    }

    private CompletableFuture<Void> completeTransaction(TransactionId transactionId, TransactionState expectState, Function<TransactionInfo, TransactionInfo> updateFunction, Predicate<TransactionInfo> updatedPredicate, BiFunction<TransactionId, Transactional<?>, CompletableFuture<Void>> completionFunction) {
        return this.transactions.compute(transactionId, (id, info) -> {
            if (info == null) {
                return null;
            }
            if (((TransactionInfo)info).state == expectState) {
                return (TransactionInfo)updateFunction.apply((TransactionInfo)info);
            }
            return info;
        }).thenCompose(value -> {
            if (value != null && updatedPredicate.test((TransactionInfo)value.value())) {
                return Futures.allOf(((TransactionInfo)value.value()).participants.stream().map(participantInfo -> this.completeParticipant((ParticipantInfo)participantInfo, info -> (CompletableFuture)completionFunction.apply(transactionId, (Transactional<?>)info)))).thenApply(v -> null);
            }
            return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Failed to acquire transaction lock")));
        });
    }

    private CompletableFuture<Void> completeParticipant(ParticipantInfo participantInfo, Function<Transactional<?>, CompletableFuture<Void>> completionFunction) {
        PrimitiveType primitiveType = this.managementService.getPrimitiveTypeRegistry().getPrimitiveType(participantInfo.type());
        if (primitiveType == null) {
            return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Failed to locate primitive type " + participantInfo.type() + " for participant " + participantInfo.name())));
        }
        PrimitiveProtocol.Type protocolType = this.managementService.getProtocolTypeRegistry().getProtocolType(participantInfo.protocol());
        if (protocolType == null) {
            return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Failed to locate protocol type for participant " + participantInfo.name())));
        }
        PartitionGroup partitionGroup = participantInfo.group() == null ? this.managementService.getPartitionService().getPartitionGroup(protocolType) : this.managementService.getPartitionService().getPartitionGroup(participantInfo.group());
        if (partitionGroup == null) {
            return Futures.exceptionalFuture((Throwable)((Object)new TransactionException("Failed to locate partition group for participant " + participantInfo.name())));
        }
        PrimitiveBuilder builder = primitiveType.newBuilder(participantInfo.name(), primitiveType.newConfig(), this.managementService);
        ((ProxyCompatibleBuilder)builder).withProtocol(partitionGroup.newProtocol());
        SyncPrimitive primitive = builder.build();
        return completionFunction.apply((Transactional)primitive);
    }

    public CompletableFuture<TransactionService> start() {
        ProxyProtocol protocol = this.managementService.getPartitionService().getSystemPartitionGroup().newProtocol();
        return ((AtomicMapBuilder)((Object)((AtomicMapBuilder)AtomicMapType.instance().newBuilder("atomix-transactions", new AtomicMapConfig(), this.managementService).withSerializer(SERIALIZER)).withProtocol(protocol).withCacheEnabled())).buildAsync().thenApply(transactions -> {
            this.transactions = transactions.async();
            this.managementService.getMembershipService().addListener((EventListener)this.clusterEventListener);
            LOGGER.info("Started");
            this.started.set(true);
            return this;
        });
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            this.managementService.getMembershipService().removeListener((EventListener)this.clusterEventListener);
            return this.transactions.close().exceptionally(e -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static class TransactionInfo {
        private final MemberId coordinator;
        private final TransactionState state;
        private final Set<ParticipantInfo> participants;

        TransactionInfo(MemberId coordinator, TransactionState state, Set<ParticipantInfo> participants) {
            this.coordinator = coordinator;
            this.state = state;
            this.participants = participants;
        }
    }
}

