/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map;

import com.google.common.base.MoreObjects;
import io.atomix.utils.event.AbstractEvent;
import io.atomix.utils.time.Versioned;
import java.util.Objects;

public class AtomicMapEvent<K, V>
extends AbstractEvent<Type, K> {
    private final Versioned<V> newValue;
    private final Versioned<V> oldValue;

    public AtomicMapEvent(Type type, K key, Versioned<V> currentValue, Versioned<V> previousValue) {
        super((Enum)type, key);
        this.newValue = currentValue;
        this.oldValue = previousValue;
    }

    public K key() {
        return (K)this.subject();
    }

    public Versioned<V> newValue() {
        return this.newValue;
    }

    public Versioned<V> oldValue() {
        return this.oldValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AtomicMapEvent)) {
            return false;
        }
        AtomicMapEvent that = (AtomicMapEvent)((Object)o);
        return Objects.equals(this.type(), that.type()) && Objects.equals(this.key(), that.key()) && Objects.equals(this.newValue, that.newValue) && Objects.equals(this.oldValue, that.oldValue);
    }

    public int hashCode() {
        return Objects.hash(this.type(), this.key(), this.newValue, this.oldValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("type", (Object)this.type()).add("key", this.key()).add("newValue", this.newValue).add("oldValue", this.oldValue).toString();
    }

    public static enum Type {
        INSERT,
        UPDATE,
        REMOVE;

    }
}

