/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.map.AsyncDistributedSortedMap;
import io.atomix.core.map.DistributedSortedMap;
import io.atomix.core.map.impl.BlockingDistributedMap;
import java.util.Comparator;

public class BlockingDistributedSortedMap<K extends Comparable<K>, V>
extends BlockingDistributedMap<K, V>
implements DistributedSortedMap<K, V> {
    private final long operationTimeoutMillis;
    private final AsyncDistributedSortedMap<K, V> asyncMap;

    public BlockingDistributedSortedMap(AsyncDistributedSortedMap<K, V> asyncMap, long operationTimeoutMillis) {
        super(asyncMap, operationTimeoutMillis);
        this.asyncMap = asyncMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public Comparator<? super K> comparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DistributedSortedMap<K, V> subMap(K fromKey, K toKey) {
        return new BlockingDistributedSortedMap<K, V>(this.asyncMap.subMap(fromKey, toKey), this.operationTimeoutMillis);
    }

    @Override
    public DistributedSortedMap<K, V> headMap(K toKey) {
        return new BlockingDistributedSortedMap<K, V>(this.asyncMap.headMap(toKey), this.operationTimeoutMillis);
    }

    @Override
    public DistributedSortedMap<K, V> tailMap(K fromKey) {
        return new BlockingDistributedSortedMap<K, V>(this.asyncMap.tailMap(fromKey), this.operationTimeoutMillis);
    }

    @Override
    public K firstKey() {
        return (K)((Comparable)this.complete(this.asyncMap.firstKey()));
    }

    @Override
    public K lastKey() {
        return (K)((Comparable)this.complete(this.asyncMap.lastKey()));
    }

    @Override
    public AsyncDistributedSortedMap<K, V> async() {
        return this.asyncMap;
    }
}

