/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.queue.impl;

import io.atomix.core.collection.impl.DistributedCollectionProxy;
import io.atomix.core.queue.AsyncDistributedQueue;
import io.atomix.core.queue.DistributedQueue;
import io.atomix.core.queue.impl.BlockingDistributedQueue;
import io.atomix.core.queue.impl.DistributedQueueService;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;

public class DistributedQueueProxy
extends DistributedCollectionProxy<AsyncDistributedQueue<String>, DistributedQueueService, String>
implements AsyncDistributedQueue<String> {
    public DistributedQueueProxy(ProxyClient<DistributedQueueService> client, PrimitiveRegistry registry) {
        super(client, registry);
    }

    @Override
    public CompletableFuture<Boolean> offer(String s) {
        return this.getProxyClient().applyBy(this.name(), service -> service.offer(s));
    }

    @Override
    public CompletableFuture<String> remove() {
        return this.getProxyClient().applyBy(this.name(), service -> service.remove()).thenCompose(value -> {
            if (value == null) {
                return Futures.exceptionalFuture((Throwable)new NoSuchElementException());
            }
            return CompletableFuture.completedFuture(value);
        });
    }

    @Override
    public CompletableFuture<String> poll() {
        return this.getProxyClient().applyBy(this.name(), service -> service.poll());
    }

    @Override
    public CompletableFuture<String> element() {
        return this.getProxyClient().applyBy(this.name(), service -> service.element()).thenCompose(value -> {
            if (value == null) {
                return Futures.exceptionalFuture((Throwable)new NoSuchElementException());
            }
            return CompletableFuture.completedFuture(value);
        });
    }

    @Override
    public CompletableFuture<String> peek() {
        return this.getProxyClient().applyBy(this.name(), service -> service.peek());
    }

    @Override
    public DistributedQueue<String> sync(Duration operationTimeout) {
        return new BlockingDistributedQueue<String>(this, operationTimeout.toMillis());
    }
}

