/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.queue.impl;

import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.impl.UnmodifiableAsyncDistributedCollection;
import io.atomix.core.queue.AsyncDistributedQueue;
import io.atomix.core.queue.DistributedQueue;
import io.atomix.core.queue.impl.BlockingDistributedQueue;
import io.atomix.utils.concurrent.Futures;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class UnmodifiableAsyncDistributedQueue<E>
extends UnmodifiableAsyncDistributedCollection<E>
implements AsyncDistributedQueue<E> {
    private static final String ERROR_MSG = "updates are not allowed";

    public UnmodifiableAsyncDistributedQueue(AsyncDistributedCollection<E> delegateCollection) {
        super(delegateCollection);
    }

    @Override
    public CompletableFuture<Boolean> offer(E e) {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<E> remove() {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<E> poll() {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<E> element() {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<E> peek() {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public DistributedQueue<E> sync(Duration operationTimeout) {
        return new BlockingDistributedQueue(this, operationTimeout.toMillis());
    }
}

