/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import com.google.common.io.BaseEncoding;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.DistributedSetBuilder;
import io.atomix.core.set.DistributedSetConfig;
import io.atomix.core.set.impl.CachingAsyncDistributedSet;
import io.atomix.core.set.impl.DistributedSetProxy;
import io.atomix.core.set.impl.DistributedSetService;
import io.atomix.core.set.impl.GossipDistributedSet;
import io.atomix.core.set.impl.TranscodingAsyncDistributedSet;
import io.atomix.core.set.impl.UnmodifiableAsyncDistributedSet;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.primitive.protocol.GossipProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.set.SetProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedSetBuilder<E>
extends DistributedSetBuilder<E> {
    public DefaultDistributedSetBuilder(String name, DistributedSetConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedSet<E>> buildAsync() {
        PrimitiveProtocol protocol = this.protocol();
        if (protocol instanceof GossipProtocol) {
            if (protocol instanceof SetProtocol) {
                return this.managementService.getPrimitiveCache().getPrimitive(this.name, () -> CompletableFuture.completedFuture(((SetProtocol)protocol).newSetDelegate(this.name, this.serializer(), this.managementService)).thenApply(set -> new GossipDistributedSet(this.name, protocol, set))).thenApply(AsyncDistributedSet::sync);
            }
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException("Sets are not supported by the provided gossip protocol"));
        }
        return ((CompletableFuture)this.newProxy(DistributedSetService.class, new ServiceConfig()).thenCompose(proxy -> new DistributedSetProxy((ProxyClient<DistributedSetService<String>>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(rawSet -> {
            Serializer serializer = this.serializer();
            DelegatingAsyncPrimitive set = new TranscodingAsyncDistributedSet<Object, String>((AsyncDistributedSet<String>)rawSet, element -> BaseEncoding.base16().encode(serializer.encode(element)), string -> serializer.decode(BaseEncoding.base16().decode((CharSequence)string)));
            if (((DistributedSetConfig)this.config).getCacheConfig().isEnabled()) {
                set = new CachingAsyncDistributedSet(set, ((DistributedSetConfig)this.config).getCacheConfig());
            }
            if (((DistributedSetConfig)this.config).isReadOnly()) {
                set = new UnmodifiableAsyncDistributedSet(set);
            }
            return set.sync();
        });
    }
}

