/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.set.impl.AsyncDistributedNavigableJavaSet;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.set.NavigableSetDelegate;
import io.atomix.primitive.protocol.set.SetDelegate;
import io.atomix.primitive.protocol.set.SetDelegateEvent;
import io.atomix.primitive.protocol.set.SetDelegateEventListener;
import io.atomix.utils.event.Event;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class GossipDistributedNavigableSet<E extends Comparable<E>>
extends AsyncDistributedNavigableJavaSet<E> {
    private final SetDelegate<E> set;
    private final Map<CollectionEventListener<E>, SetDelegateEventListener<E>> listenerMap = Maps.newConcurrentMap();

    public GossipDistributedNavigableSet(String name, PrimitiveProtocol protocol, NavigableSetDelegate<E> set) {
        super(name, protocol, set);
        this.set = set;
    }

    @Override
    public CompletableFuture<Void> addListener(CollectionEventListener<E> listener) {
        SetDelegateEventListener eventListener = event -> {
            switch ((SetDelegateEvent.Type)event.type()) {
                case ADD: {
                    listener.event((Event)new CollectionEvent<Object>(CollectionEvent.Type.ADD, event.element()));
                    break;
                }
                case REMOVE: {
                    listener.event((Event)new CollectionEvent<Object>(CollectionEvent.Type.REMOVE, event.element()));
                    break;
                }
            }
        };
        if (this.listenerMap.putIfAbsent(listener, eventListener) == null) {
            this.set.addListener(eventListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(CollectionEventListener<E> listener) {
        SetDelegateEventListener<E> eventListener = this.listenerMap.remove(listener);
        if (eventListener != null) {
            this.set.removeListener(eventListener);
        }
        return CompletableFuture.completedFuture(null);
    }
}

