/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ParticipantInfo {
    private final String name;
    private final String type;
    private final String protocol;
    private final String group;

    public ParticipantInfo(String name, String type, String protocol, String group) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.protocol = (String)Preconditions.checkNotNull((Object)protocol);
        this.group = group;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String protocol() {
        return this.protocol;
    }

    public String group() {
        return this.group;
    }

    public boolean equals(Object object) {
        if (object instanceof ParticipantInfo) {
            ParticipantInfo info = (ParticipantInfo)object;
            return this.name.equals(info.name) && this.type.equals(info.type) && this.protocol.equals(info.protocol) && Objects.equals(this.group, info.group);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name(), this.type(), this.protocol(), this.group());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name()).add("type", (Object)this.type()).add("protocol", (Object)this.protocol()).add("group", (Object)this.group()).toString();
    }
}

