/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeNode;
import io.atomix.primitive.Ordering;
import io.atomix.utils.time.Versioned;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class DefaultDocumentTreeNode<V>
implements DocumentTreeNode<V> {
    private final DocumentPath key;
    private Versioned<V> value;
    private final Map<String, DocumentTreeNode<V>> children;
    private final Ordering ordering;
    private final DocumentTreeNode<V> parent;

    public DefaultDocumentTreeNode(DocumentPath key, V value, long version, Ordering ordering, DocumentTreeNode<V> parent) {
        this.key = (DocumentPath)Preconditions.checkNotNull((Object)key);
        this.value = new Versioned(value, version);
        this.ordering = ordering;
        this.parent = parent;
        switch (ordering) {
            case INSERTION: {
                this.children = Maps.newLinkedHashMap();
                break;
            }
            default: {
                this.children = Maps.newTreeMap();
            }
        }
    }

    @Override
    public DocumentPath path() {
        return this.key;
    }

    @Override
    public Versioned<V> value() {
        return this.value;
    }

    @Override
    public Iterator<DocumentTreeNode<V>> children() {
        return ImmutableList.copyOf(this.children.values()).iterator();
    }

    @Override
    public DocumentTreeNode<V> child(String name) {
        return this.children.get(name);
    }

    public DocumentTreeNode<V> parent() {
        return this.parent;
    }

    public Versioned<V> addChild(String name, V newValue, long newVersion) {
        DefaultDocumentTreeNode child = (DefaultDocumentTreeNode)this.children.get(name);
        if (child != null) {
            return child.value();
        }
        this.children.put(name, new DefaultDocumentTreeNode<V>(new DocumentPath(name, this.path()), newValue, newVersion, this.ordering, this));
        return null;
    }

    public Versioned<V> update(V newValue, long newVersion) {
        Versioned<V> previousValue = this.value;
        this.value = new Versioned(newValue, newVersion);
        return previousValue;
    }

    public boolean removeChild(String name) {
        return this.children.remove(name) != null;
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultDocumentTreeNode) {
            DefaultDocumentTreeNode that = (DefaultDocumentTreeNode)obj;
            if (this.parent.equals(that.parent) && this.children.size() == that.children.size()) {
                return Sets.symmetricDifference(this.children.keySet(), that.children.keySet()).isEmpty();
            }
        }
        return false;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this.getClass()).add("parent", this.parent).add("key", (Object)this.key).add("value", this.value);
        for (DocumentTreeNode<V> child : this.children.values()) {
            helper = helper.add("child", (Object)("\n" + child.path().pathElements().get(child.path().pathElements().size() - 1) + " : " + child.value()));
        }
        return helper.toString();
    }
}

