/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import io.atomix.core.tree.AsyncAtomicDocumentTree;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEvent;
import io.atomix.core.tree.DocumentTreeEventListener;
import io.atomix.core.tree.impl.BlockingAtomicDocumentTree;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class TranscodingAsyncAtomicDocumentTree<V1, V2>
extends DelegatingAsyncPrimitive
implements AsyncAtomicDocumentTree<V1> {
    private final AsyncAtomicDocumentTree<V2> backingTree;
    private final Function<V1, V2> valueEncoder;
    private final Function<V2, V1> valueDecoder;
    private final Map<DocumentTreeEventListener<V1>, InternalDocumentTreeListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncAtomicDocumentTree(AsyncAtomicDocumentTree<V2> backingTree, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        super(backingTree);
        this.backingTree = backingTree;
        this.valueEncoder = valueEncoder;
        this.valueDecoder = valueDecoder;
    }

    @Override
    public DocumentPath root() {
        return this.backingTree.root();
    }

    @Override
    public CompletableFuture<Map<String, Versioned<V1>>> getChildren(DocumentPath path) {
        return this.backingTree.getChildren(path).thenApply(children -> Maps.transformValues((Map)children, v -> v.map(this.valueDecoder)));
    }

    @Override
    public CompletableFuture<Versioned<V1>> get(DocumentPath path) {
        return this.backingTree.get(path).thenApply(v -> v != null ? v.map(this.valueDecoder) : null);
    }

    @Override
    public CompletableFuture<Versioned<V1>> set(DocumentPath path, V1 value) {
        return this.backingTree.set(path, this.valueEncoder.apply(value)).thenApply(v -> v != null ? v.map(this.valueDecoder) : null);
    }

    @Override
    public CompletableFuture<Boolean> create(DocumentPath path, V1 value) {
        return this.backingTree.create(path, this.valueEncoder.apply(value));
    }

    @Override
    public CompletableFuture<Boolean> createRecursive(DocumentPath path, V1 value) {
        return this.backingTree.createRecursive(path, this.valueEncoder.apply(value));
    }

    @Override
    public CompletableFuture<Boolean> replace(DocumentPath path, V1 newValue, long version) {
        return this.backingTree.replace(path, this.valueEncoder.apply(newValue), (V2)version);
    }

    @Override
    public CompletableFuture<Boolean> replace(DocumentPath path, V1 newValue, V1 currentValue) {
        return this.backingTree.replace(path, this.valueEncoder.apply(newValue), this.valueEncoder.apply(currentValue));
    }

    @Override
    public CompletableFuture<Versioned<V1>> removeNode(DocumentPath path) {
        return this.backingTree.removeNode(path).thenApply(v -> v != null ? v.map(this.valueDecoder) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(DocumentPath path, DocumentTreeEventListener<V1> listener, Executor executor) {
        Map<DocumentTreeEventListener<V1>, InternalDocumentTreeListener> map = this.listeners;
        synchronized (map) {
            InternalDocumentTreeListener internalListener = this.listeners.computeIfAbsent(listener, k -> new InternalDocumentTreeListener(listener));
            return this.backingTree.addListener(path, internalListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeListener(DocumentTreeEventListener<V1> listener) {
        Map<DocumentTreeEventListener<V1>, InternalDocumentTreeListener> map = this.listeners;
        synchronized (map) {
            InternalDocumentTreeListener internalListener = this.listeners.remove(listener);
            if (internalListener != null) {
                return this.backingTree.removeListener(internalListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    public CompletableFuture<Void> delete() {
        return this.backingTree.delete();
    }

    @Override
    public AtomicDocumentTree<V1> sync(Duration operationTimeout) {
        return new BlockingAtomicDocumentTree(this, operationTimeout.toMillis());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("backingTree", this.backingTree).toString();
    }

    private class InternalDocumentTreeListener
    implements DocumentTreeEventListener<V2> {
        private final DocumentTreeEventListener<V1> listener;

        InternalDocumentTreeListener(DocumentTreeEventListener<V1> listener) {
            this.listener = listener;
        }

        public void event(DocumentTreeEvent<V2> event) {
            this.listener.event((Event)new DocumentTreeEvent((DocumentTreeEvent.Type)event.type(), event.path(), event.newValue().map(v -> v.map(TranscodingAsyncAtomicDocumentTree.this.valueDecoder)), event.oldValue().map(v -> v.map(TranscodingAsyncAtomicDocumentTree.this.valueDecoder))));
        }
    }
}

