/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.ImportTagCycleException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Allows you to access and use macros from a different template", params={@JinjavaParam(value="path", desc="Design Manager path to file to import"), @JinjavaParam(value="import_name", desc="Give a name to the imported file to access macros from")}, snippets={@JinjavaSnippet(desc="This example uses an html file containing two macros.", code="{% macro header(tag, title_text) %}\n<header> <{{ tag }}>{{ title_text }} </{{tag}}> </header>\n{% endmacro %}\n{% macro footer(tag, footer_text) %}\n<footer> <{{ tag }}>{{ footer_text }} </{{tag}}> </footer>\n{% endmacro %}"), @JinjavaSnippet(desc="The macro html file is imported from a different template. Macros are then accessed from the name given to the import.", code="{% import 'custom/page/web_page_basic/my_macros.html' as header_footer %}\n{{ header_footer.header('h1', 'My page title') }}\n{{ header_footer.footer('h3', 'Company footer info') }}")})
public class ImportTag
implements Tag {
    public static final String TAG_NAME = "import";
    private static final long serialVersionUID = 8433638845398005260L;

    @Override
    public String getName() {
        return TAG_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        List<String> helper = new HelperStringTokenizer(tagNode.getHelpers()).allTokens();
        if (helper.isEmpty()) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'import' expects 1 helper, was: " + helper.size(), tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        String contextVar = "";
        if (helper.size() > 2 && "as".equals(helper.get(1))) {
            contextVar = helper.get(2);
        }
        String path = StringUtils.trimToEmpty(helper.get(0));
        try {
            interpreter.getContext().getImportPathStack().push(path, tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        catch (ImportTagCycleException e) {
            interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Import cycle detected for path: '" + path + "'", null, tagNode.getLineNumber(), tagNode.getStartPosition(), e, BasicTemplateErrorCategory.IMPORT_CYCLE_DETECTED, ImmutableMap.of("path", path)));
            return "";
        }
        String templateFile = interpreter.resolveString(path, tagNode.getLineNumber(), tagNode.getStartPosition());
        templateFile = interpreter.resolveResourceLocation(templateFile);
        interpreter.getContext().addDependency("coded_files", templateFile);
        try {
            interpreter.getContext().getCurrentPathStack().push(templateFile, interpreter.getLineNumber(), interpreter.getPosition());
            String template = interpreter.getResource(templateFile);
            Node node = interpreter.parse(template);
            JinjavaInterpreter child = interpreter.getConfig().getInterpreterFactory().newInstance(interpreter);
            child.getContext().put("import_resource_path", templateFile);
            JinjavaInterpreter.pushCurrent(child);
            try {
                child.render(node);
            }
            finally {
                JinjavaInterpreter.popCurrent();
            }
            interpreter.addAllChildErrors(templateFile, child.getErrorsCopy());
            Map<String, Object> childBindings = child.getContext().getSessionBindings();
            if (!child.getContext().getDeferredNodes().isEmpty()) {
                node.getChildren().forEach(deferredChild -> interpreter.getContext().addDeferredNode((Node)deferredChild));
                if (StringUtils.isBlank(contextVar)) {
                    for (MacroFunction macroFunction : child.getContext().getGlobalMacros().values()) {
                        macroFunction.setDeferred(true);
                        interpreter.getContext().addGlobalMacro(macroFunction);
                    }
                    childBindings.remove("__macros__");
                    childBindings.remove("import_resource_path");
                    childBindings.keySet().forEach(key -> interpreter.getContext().put(key, DeferredValue.instance()));
                } else {
                    for (Map.Entry<String, MacroFunction> entry : child.getContext().getGlobalMacros().entrySet()) {
                        MacroFunction macro = entry.getValue();
                        macro.setDeferred(true);
                        childBindings.put(entry.getKey(), macro);
                    }
                    childBindings.remove("__macros__");
                    childBindings.remove("import_resource_path");
                    for (String string : childBindings.keySet()) {
                        childBindings.put(string, DeferredValue.instance());
                    }
                    interpreter.getContext().put(contextVar, childBindings);
                }
                throw new DeferredValueException(templateFile, tagNode.getLineNumber(), tagNode.getStartPosition());
            }
            if (StringUtils.isBlank(contextVar)) {
                for (MacroFunction macroFunction : child.getContext().getGlobalMacros().values()) {
                    interpreter.getContext().addGlobalMacro(macroFunction);
                }
                childBindings.remove("__macros__");
                interpreter.getContext().putAll(childBindings);
            } else {
                for (Map.Entry entry : child.getContext().getGlobalMacros().entrySet()) {
                    childBindings.put((String)entry.getKey(), entry.getValue());
                }
                childBindings.remove("__macros__");
                interpreter.getContext().put(contextVar, childBindings);
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            throw new InterpretException(e.getMessage(), (Throwable)e, tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        finally {
            interpreter.getContext().getCurrentPathStack().pop();
        }
    }

    @Override
    public String getEndTagName() {
        return null;
    }
}

