/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.util;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.pty4j.util.ExtractedNative;
import com.pty4j.windows.WinPty;
import com.sun.jna.Platform;
import java.io.File;
import java.net.URI;
import java.security.CodeSource;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PtyUtil {
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase();
    private static final String PTY_LIB_FOLDER = System.getenv("PTY_LIB_FOLDER");
    public static final String PREFERRED_NATIVE_FOLDER_KEY = "pty4j.preferred.native.folder";

    public static String[] toStringArray(Map<String, String> environment) {
        if (environment == null) {
            return new String[0];
        }
        List<String> list = Lists.transform(Lists.newArrayList(environment.entrySet()), new Function<Map.Entry<String, String>, String>(){

            @Override
            public String apply(Map.Entry<String, String> entry) {
                return entry.getKey() + "=" + entry.getValue();
            }
        });
        return list.toArray(new String[list.size()]);
    }

    public static String getJarContainingFolderPath(Class aclass) throws Exception {
        File jarFile;
        CodeSource codeSource = aclass.getProtectionDomain().getCodeSource();
        if (codeSource.getLocation() != null) {
            jarFile = new File(codeSource.getLocation().toURI());
        } else {
            String path = aclass.getResource(aclass.getSimpleName() + ".class").getPath();
            int startIndex = path.indexOf(":") + 1;
            int endIndex = path.indexOf("!");
            if (startIndex == -1 || endIndex == -1) {
                throw new IllegalStateException("Class " + aclass.getSimpleName() + " is located not within a jar: " + path);
            }
            String jarFilePath = path.substring(startIndex, endIndex);
            jarFilePath = new URI(jarFilePath).getPath();
            jarFile = new File(jarFilePath);
        }
        return jarFile.getParentFile().getAbsolutePath();
    }

    @Deprecated
    public static String getPtyLibFolderPath() throws Exception {
        File file = PtyUtil.getPreferredLibPtyFolder();
        return file != null ? file.getAbsolutePath() : null;
    }

    @Nullable
    private static File getPreferredLibPtyFolder() {
        File dir;
        String path;
        if (PTY_LIB_FOLDER != null) {
            System.err.println("WARN: PTY_LIB_FOLDER environment variable is deprecated and will not be used in future releases. Please set Java system property \"pty4j.preferred.native.folder\" instead.");
        }
        String string = path = PTY_LIB_FOLDER != null ? PTY_LIB_FOLDER : System.getProperty(PREFERRED_NATIVE_FOLDER_KEY);
        if (path != null && (dir = new File(path)).isAbsolute() && dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    @NotNull
    public static File resolveNativeLibrary() throws Exception {
        return PtyUtil.resolveNativeFile(PtyUtil.getNativeLibraryName());
    }

    @Deprecated
    public static File resolveNativeLibrary(File parent) {
        return PtyUtil.resolveNativeFileFromFS(parent, PtyUtil.getNativeLibraryName());
    }

    @NotNull
    public static File resolveNativeFile(@NotNull String fileName) throws Exception {
        File preferredLibPtyFolder = PtyUtil.getPreferredLibPtyFolder();
        if (preferredLibPtyFolder != null) {
            return PtyUtil.resolveNativeFileFromFS(preferredLibPtyFolder, fileName);
        }
        try {
            File destDir = ExtractedNative.getInstance().getDestDir();
            return new File(destDir, fileName);
        }
        catch (Exception e) {
            Exception extractException = e;
            File jarParentFolder = new File(PtyUtil.getJarContainingFolderPath(WinPty.class));
            File file = PtyUtil.resolveNativeFileFromFS(jarParentFolder, fileName);
            if (!file.exists()) {
                file = PtyUtil.resolveNativeFileFromFS(new File(jarParentFolder, "libpty"), fileName);
            }
            if (file.exists()) {
                return file;
            }
            throw extractException;
        }
    }

    @NotNull
    private static File resolveNativeFileFromFS(@NotNull File libPtyFolder, @NotNull String fileName) {
        File platformFolder = new File(libPtyFolder, PtyUtil.getPlatformFolderName());
        String prefix = PtyUtil.getPlatformArchFolderName();
        if (new File(libPtyFolder, prefix).exists()) {
            return new File(new File(libPtyFolder, prefix), fileName);
        }
        return new File(new File(platformFolder, prefix), fileName);
    }

    @Deprecated
    public static File resolveNativeFile(File libPtyFolder, String fileName) {
        return PtyUtil.resolveNativeFileFromFS(libPtyFolder, fileName);
    }

    @NotNull
    static String getPlatformArchFolderName() {
        if (PtyUtil.isWinXp()) {
            return "xp";
        }
        if (System.getProperty("os.arch").equals("ppc64le")) {
            return "ppc64le";
        }
        return Platform.is64Bit() ? "x86_64" : "x86";
    }

    @NotNull
    static String getPlatformFolderName() {
        String result;
        if (Platform.isMac()) {
            result = "macosx";
        } else if (Platform.isWindows()) {
            result = "win";
        } else if (Platform.isLinux() || Platform.isAndroid()) {
            result = "linux";
        } else if (Platform.isFreeBSD()) {
            result = "freebsd";
        } else if (Platform.isOpenBSD()) {
            result = "openbsd";
        } else {
            throw new IllegalStateException("Platform " + Platform.getOSType() + " is not supported");
        }
        return result;
    }

    private static String getNativeLibraryName() {
        String result;
        if (Platform.isMac()) {
            result = "libpty.dylib";
        } else if (Platform.isWindows()) {
            result = "winpty.dll";
        } else if (Platform.isLinux() || Platform.isFreeBSD() || Platform.isOpenBSD() || Platform.isAndroid()) {
            result = "libpty.so";
        } else {
            throw new IllegalStateException("Platform " + Platform.getOSType() + " is not supported");
        }
        return result;
    }

    private static boolean isWinXp() {
        return Platform.isWindows() && (OS_VERSION.equals("5.1") || OS_VERSION.equals("5.2"));
    }
}

