/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell.terminal;

import java.net.URL;
import org.apache.zeppelin.shell.terminal.websocket.TerminalSocket;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalThread.class);
    private Server jettyServer = new Server();
    private int port = 0;

    public TerminalThread(int port) {
        this.port = port;
    }

    @Override
    public void run() {
        ServerConnector connector = new ServerConnector(this.jettyServer);
        connector.setPort(this.port);
        this.jettyServer.addConnector(connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/terminal/");
        ClassLoader clazz = TerminalThread.class.getClassLoader();
        URL url = clazz.getResource("html");
        if (url == null) {
            throw new RuntimeException("Unable to find resource directory");
        }
        ResourceHandler resourceHandler = new ResourceHandler();
        String webRootUri = url.toExternalForm();
        LOGGER.info("WebRoot is " + webRootUri);
        resourceHandler.setResourceBase(webRootUri);
        HandlerCollection handlers = new HandlerCollection(context, resourceHandler);
        this.jettyServer.setHandler(handlers);
        try {
            ServerContainer container = WebSocketServerContainerInitializer.configureContext(context);
            container.addEndpoint(TerminalSocket.class);
            this.jettyServer.start();
            this.jettyServer.join();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    public void stopRunning() {
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
        LOGGER.info("stop TerminalThread");
    }
}

