/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.submarine.job.SubmarineJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineContext {
    private Logger LOGGER = LoggerFactory.getLogger(SubmarineContext.class);
    private static SubmarineContext instance = null;
    private Map<String, SubmarineJob> mapSubmarineJob = new HashMap<String, SubmarineJob>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubmarineContext getInstance() {
        Class<SubmarineContext> clazz = SubmarineContext.class;
        synchronized (SubmarineContext.class) {
            if (instance == null) {
                instance = new SubmarineContext();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SubmarineJob addOrGetSubmarineJob(Properties properties, InterpreterContext context) {
        SubmarineJob submarineJob = null;
        String noteId = context.getNoteId();
        if (!this.mapSubmarineJob.containsKey(noteId)) {
            submarineJob = new SubmarineJob(context, properties);
            this.mapSubmarineJob.put(noteId, submarineJob);
        } else {
            submarineJob = this.mapSubmarineJob.get(noteId);
        }
        submarineJob.setIntpContext(context);
        return submarineJob;
    }

    public SubmarineJob getSubmarineJob(String nodeId) {
        if (!this.mapSubmarineJob.containsKey(nodeId)) {
            return null;
        }
        return this.mapSubmarineJob.get(nodeId);
    }

    public void stopAllSubmarineJob() {
        for (Map.Entry<String, SubmarineJob> entry : this.mapSubmarineJob.entrySet()) {
            entry.getValue().stopRunning();
        }
    }
}

