/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.display.ui.OptionInput;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.submarine.SubmarineContext;
import org.apache.zeppelin.submarine.commons.SubmarineCommand;
import org.apache.zeppelin.submarine.commons.SubmarineUtils;
import org.apache.zeppelin.submarine.job.SubmarineJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineInterpreter
extends Interpreter {
    private Logger LOGGER = LoggerFactory.getLogger(SubmarineInterpreter.class);
    protected int concurrentExecutedMax = 1;
    private boolean needUpdateConfig = true;
    private String currentReplName = "";
    private SubmarineContext submarineContext = null;

    public SubmarineInterpreter(Properties properties) {
        super(properties);
        String concurrentMax = this.getProperty("submarine.concurrent.max", "1");
        this.concurrentExecutedMax = Integer.parseInt(concurrentMax);
        this.submarineContext = SubmarineContext.getInstance();
    }

    public void open() {
        this.LOGGER.info("SubmarineInterpreter open()");
    }

    public void close() {
        this.submarineContext.stopAllSubmarineJob();
    }

    private void setParagraphConfig(InterpreterContext context) {
        context.getConfig().put("editorHide", true);
        context.getConfig().put("title", false);
    }

    public InterpreterResult interpret(String script, InterpreterContext context) {
        try {
            String checkpointPath;
            this.setParagraphConfig(context);
            String algorithmPath = this.properties.getProperty("submarine.algorithm.hdfs.path", "");
            if (algorithmPath.contains("${username}")) {
                algorithmPath = algorithmPath.replace("${username}", this.userName);
                this.properties.setProperty("submarine.algorithm.hdfs.path", algorithmPath);
            }
            if ((checkpointPath = this.properties.getProperty("tf.checkpoint.path", "")).contains("${username}")) {
                checkpointPath = checkpointPath.replace("${username}", this.userName);
                this.properties.setProperty("tf.checkpoint.path", checkpointPath);
            }
            SubmarineJob submarineJob = this.submarineContext.addOrGetSubmarineJob(this.properties, context);
            this.LOGGER.debug("Run shell command '" + script + "'");
            String command = "";
            String operation = "";
            String cleanCheckpoint = "";
            String inputPath = "";
            String chkPntPath = "";
            String psLaunchCmd = "";
            String workerLaunchCmd = "";
            String noteId = context.getNoteId();
            String noteName = context.getNoteName();
            if (script.equalsIgnoreCase("CLEAN")) {
                command = SubmarineCommand.CLEAN_RUNTIME_CACHE.getCommand();
            } else {
                operation = SubmarineUtils.getAgulObjValue(context, "OPERATION_TYPE");
                if (!StringUtils.isEmpty(operation)) {
                    SubmarineUtils.removeAgulObjValue(context, "OPERATION_TYPE");
                    command = operation;
                } else {
                    command = SubmarineUtils.getAgulObjValue(context, "COMMAND_TYPE");
                }
            }
            String distributed = this.properties.getProperty("machinelearning.distributed.enable", "false");
            SubmarineUtils.setAgulObjValue(context, SubmarineUtils.unifyKey("machinelearning.distributed.enable"), distributed);
            inputPath = SubmarineUtils.getAgulObjValue(context, "INPUT_PATH");
            cleanCheckpoint = SubmarineUtils.getAgulObjValue(context, "CLEAN_CHECKPOINT");
            chkPntPath = submarineJob.getJobDefaultCheckpointPath();
            SubmarineUtils.setAgulObjValue(context, "CHECKPOINT_PATH", chkPntPath);
            psLaunchCmd = SubmarineUtils.getAgulObjValue(context, "PS_LAUNCH_CMD");
            workerLaunchCmd = SubmarineUtils.getAgulObjValue(context, "WORKER_LAUNCH_CMD");
            this.properties.put("INPUT_PATH", inputPath != null ? inputPath : "");
            this.properties.put("CHECKPOINT_PATH", chkPntPath != null ? chkPntPath : "");
            this.properties.put("PS_LAUNCH_CMD", psLaunchCmd != null ? psLaunchCmd : "");
            this.properties.put("WORKER_LAUNCH_CMD", workerLaunchCmd != null ? workerLaunchCmd : "");
            SubmarineCommand submarineCmd = SubmarineCommand.fromCommand(command);
            switch (submarineCmd) {
                case USAGE: {
                    submarineJob.showUsage();
                    break;
                }
                case JOB_RUN: {
                    if (StringUtils.equals(cleanCheckpoint, "true")) {
                        submarineJob.cleanJobDefaultCheckpointPath();
                    }
                    submarineJob.runJob();
                    break;
                }
                case JOB_STOP: {
                    String jobName = SubmarineUtils.getJobName(this.userName, noteId);
                    submarineJob.deleteJob(jobName);
                    break;
                }
                case TENSORBOARD_RUN: {
                    submarineJob.runTensorBoard();
                    break;
                }
                case TENSORBOARD_STOP: {
                    String user = context.getAuthenticationInfo().getUser();
                    String tensorboardName = SubmarineUtils.getTensorboardName(user);
                    submarineJob.deleteJob(tensorboardName);
                    break;
                }
                case OLD_UI: {
                    this.createOldGUI(context);
                    break;
                }
                case CLEAN_RUNTIME_CACHE: {
                    submarineJob.cleanRuntimeCache();
                    break;
                }
                default: {
                    submarineJob.onDashboard();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS);
    }

    public void cancel(InterpreterContext context) {
        SubmarineJob submarineJob = this.submarineContext.addOrGetSubmarineJob(this.properties, context);
        String userName = context.getAuthenticationInfo().getUser();
        String noteId = context.getNoteId();
        String jobName = SubmarineUtils.getJobName(userName, noteId);
        submarineJob.deleteJob(jobName);
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        String schedulerName = SubmarineInterpreter.class.getName() + ((Object)((Object)this)).hashCode();
        if (this.concurrentExecutedMax > 1) {
            return SchedulerFactory.singleton().createOrGetParallelScheduler(schedulerName, this.concurrentExecutedMax);
        }
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(schedulerName);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext intpContext) {
        return null;
    }

    public void setPythonWorkDir(String noteId, File pythonWorkDir) {
        SubmarineJob submarineJob = this.submarineContext.getSubmarineJob(noteId);
        if (null != submarineJob) {
            submarineJob.setPythonWorkDir(pythonWorkDir);
        }
    }

    private String createOldGUI(InterpreterContext context) {
        OptionInput.ParamOption[] commandOptions = new OptionInput.ParamOption[4];
        commandOptions[0] = new OptionInput.ParamOption((Object)"JOB RUN", "JOB RUN");
        commandOptions[1] = new OptionInput.ParamOption((Object)"JOB SHOW", "JOB SHOW");
        commandOptions[2] = new OptionInput.ParamOption((Object)"USAGE", "USAGE");
        String command = (String)context.getGui().select("Submarine Command", commandOptions, (Object)"");
        String distributed = this.properties.getProperty("machinelearning.distributed.enable", "false");
        if (command.equals("JOB RUN")) {
            String string;
            String inputPath = (String)context.getGui().textbox("Input Path(input_path)");
            String checkpoinkPath = (String)context.getGui().textbox("Checkpoint Path(checkpoint_path)");
            if (distributed.equals("true")) {
                string = (String)context.getGui().textbox("PS Launch Command");
            }
            string = (String)context.getGui().textbox("Worker Launch Command");
        }
        return command;
    }

    @VisibleForTesting
    public SubmarineContext getSubmarineContext() {
        return this.submarineContext;
    }
}

