/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.cql.continuous.ContinuousAsyncResultSet;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.dse.driver.internal.core.cql.DseConversions;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousRequestHandlerBase;
import com.datastax.dse.driver.internal.core.cql.continuous.DefaultContinuousAsyncResultSet;
import com.datastax.dse.protocol.internal.response.result.DseRowsMetadata;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.internal.core.cql.DefaultRow;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.result.Rows;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ContinuousCqlRequestHandler
extends ContinuousRequestHandlerBase<Statement<?>, ContinuousAsyncResultSet> {
    ContinuousCqlRequestHandler(@NonNull Statement<?> statement, @NonNull DefaultSession session, @NonNull InternalDriverContext context, @NonNull String sessionLogPrefix) {
        super(statement, session, context, sessionLogPrefix, ContinuousAsyncResultSet.class, false, DefaultSessionMetric.CQL_CLIENT_TIMEOUTS, DseSessionMetric.CONTINUOUS_CQL_REQUESTS, DefaultNodeMetric.CQL_MESSAGES);
        this.throttler.register(this);
    }

    @Override
    @NonNull
    protected Duration getGlobalTimeout() {
        return Duration.ZERO;
    }

    @Override
    @NonNull
    protected Duration getPageTimeout(@NonNull Statement<?> statement, int pageNumber) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, this.context);
        if (pageNumber == 1) {
            return executionProfile.getDuration(DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE);
        }
        return executionProfile.getDuration(DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES);
    }

    @Override
    @NonNull
    protected Duration getReviseRequestTimeout(@NonNull Statement<?> statement) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, this.context);
        return executionProfile.getDuration(DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES);
    }

    @Override
    protected int getMaxEnqueuedPages(@NonNull Statement<?> statement) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, this.context);
        return executionProfile.getInt(DseDriverOption.CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES);
    }

    @Override
    protected int getMaxPages(@NonNull Statement<?> statement) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, this.context);
        return executionProfile.getInt(DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES);
    }

    @Override
    @NonNull
    protected Message getMessage(@NonNull Statement<?> statement) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, this.context);
        return DseConversions.toContinuousPagingMessage(statement, executionProfile, this.context);
    }

    @Override
    protected boolean isTracingEnabled(@NonNull Statement<?> statement) {
        return false;
    }

    @Override
    @NonNull
    protected Map<String, ByteBuffer> createPayload(@NonNull Statement<?> statement) {
        return statement.getCustomPayload();
    }

    @Override
    @NonNull
    protected ContinuousAsyncResultSet createEmptyResultSet(@NonNull ExecutionInfo executionInfo) {
        return DefaultContinuousAsyncResultSet.empty(executionInfo);
    }

    @Override
    @NonNull
    protected DefaultContinuousAsyncResultSet createResultSet(@NonNull Statement<?> statement, @NonNull Rows rows, @NonNull ExecutionInfo executionInfo, final @NonNull ColumnDefinitions columnDefinitions) {
        final Queue<List<ByteBuffer>> data = rows.getData();
        CountingIterator<Row> iterator = new CountingIterator<Row>(data.size()){

            @Override
            protected Row computeNext() {
                List rowData = (List)data.poll();
                return rowData == null ? (Row)this.endOfData() : new DefaultRow(columnDefinitions, rowData, ContinuousCqlRequestHandler.this.context);
            }
        };
        DseRowsMetadata metadata = (DseRowsMetadata)rows.getMetadata();
        return new DefaultContinuousAsyncResultSet(iterator, columnDefinitions, metadata.continuousPageNumber, !metadata.isLastContinuousPage, executionInfo, this);
    }

    @Override
    protected int pageNumber(@NonNull ContinuousAsyncResultSet resultSet) {
        return resultSet.pageNumber();
    }
}

