/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.NoNodeAvailableException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AllNodesFailedException
extends DriverException {
    private final Map<Node, List<Throwable>> errors;

    @Deprecated
    @NonNull
    public static AllNodesFailedException fromErrors(@Nullable Map<Node, Throwable> errors) {
        if (errors == null || errors.isEmpty()) {
            return new NoNodeAvailableException();
        }
        return new AllNodesFailedException(AllNodesFailedException.groupByNode(errors));
    }

    @NonNull
    public static AllNodesFailedException fromErrors(@Nullable List<Map.Entry<Node, Throwable>> errors) {
        if (errors == null || errors.isEmpty()) {
            return new NoNodeAvailableException();
        }
        return new AllNodesFailedException(AllNodesFailedException.groupByNode(errors));
    }

    @Deprecated
    protected AllNodesFailedException(@NonNull String message, @Nullable ExecutionInfo executionInfo, @NonNull Map<Node, Throwable> errors) {
        super(message, executionInfo, null, true);
        this.errors = AllNodesFailedException.toDeepImmutableMap(AllNodesFailedException.groupByNode(errors));
        this.addSuppressedErrors();
    }

    protected AllNodesFailedException(@NonNull String message, @Nullable ExecutionInfo executionInfo, @NonNull Iterable<Map.Entry<Node, List<Throwable>>> errors) {
        super(message, executionInfo, null, true);
        this.errors = AllNodesFailedException.toDeepImmutableMap(errors);
        this.addSuppressedErrors();
    }

    private void addSuppressedErrors() {
        for (List<Throwable> errors : this.errors.values()) {
            for (Throwable error : errors) {
                this.addSuppressed(error);
            }
        }
    }

    private AllNodesFailedException(Map<Node, List<Throwable>> errors) {
        this(AllNodesFailedException.buildMessage(String.format("All %d node(s) tried for the query failed", errors.size()), errors), null, errors.entrySet());
    }

    private static String buildMessage(String baseMessage, Map<Node, List<Throwable>> errors) {
        int limit = Math.min(errors.size(), 3);
        Iterator<Map.Entry<Node, List<Throwable>>> iterator = Iterables.limit(errors.entrySet(), limit).iterator();
        StringBuilder details = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry<Node, List<Throwable>> entry = iterator.next();
            details.append(entry.getKey()).append(": ").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            details.append(", ");
        }
        return String.format("%s (showing first %d nodes, use getAllErrors() for more): %s", baseMessage, limit, details);
    }

    @Deprecated
    @NonNull
    public Map<Node, Throwable> getErrors() {
        ImmutableMap.Builder<Node, Throwable> builder = ImmutableMap.builder();
        for (Node node : this.errors.keySet()) {
            List<Throwable> nodeErrors = this.errors.get(node);
            if (nodeErrors.isEmpty()) continue;
            builder.put(node, nodeErrors.get(0));
        }
        return builder.build();
    }

    @NonNull
    public Map<Node, List<Throwable>> getAllErrors() {
        return this.errors;
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new AllNodesFailedException(this.getMessage(), this.getExecutionInfo(), this.errors.entrySet());
    }

    @NonNull
    public AllNodesFailedException reword(String newMessage) {
        return new AllNodesFailedException(AllNodesFailedException.buildMessage(newMessage, this.errors), this.getExecutionInfo(), this.errors.entrySet());
    }

    private static Map<Node, List<Throwable>> groupByNode(Map<Node, Throwable> errors) {
        return AllNodesFailedException.groupByNode(errors.entrySet());
    }

    private static Map<Node, List<Throwable>> groupByNode(Iterable<Map.Entry<Node, Throwable>> errors) {
        LinkedHashMap<Node, List<Throwable>> map = new LinkedHashMap<Node, List<Throwable>>();
        for (Map.Entry<Node, Throwable> entry : errors) {
            Node node = entry.getKey();
            Throwable error = entry.getValue();
            map.compute(node, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Throwable>();
                }
                v.add(error);
                return v;
            });
        }
        return map;
    }

    private static Map<Node, List<Throwable>> toDeepImmutableMap(Map<Node, List<Throwable>> errors) {
        return AllNodesFailedException.toDeepImmutableMap(errors.entrySet());
    }

    private static Map<Node, List<Throwable>> toDeepImmutableMap(Iterable<Map.Entry<Node, List<Throwable>>> errors) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Node, List<Throwable>> entry : errors) {
            builder.put(entry.getKey(), ImmutableList.copyOf((Collection)entry.getValue()));
        }
        return builder.build();
    }
}

