/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.typesafe;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSortedSet;
import com.datastax.oss.driver.shaded.guava.common.collect.MapMaker;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class TypesafeDriverExecutionProfile
implements DriverExecutionProfile {
    protected final ConcurrentMap<String, Object> cache = new ConcurrentHashMap<String, Object>();

    protected abstract Base getBaseProfile();

    protected abstract Config getAddedOptions();

    protected abstract Config getEffectiveOptions();

    @Override
    public boolean isDefined(@NonNull DriverOption option) {
        return this.getEffectiveOptions().hasPath(option.getPath());
    }

    @Override
    public boolean getBoolean(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getBoolean);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withBoolean(@NonNull DriverOption option, boolean value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public List<Boolean> getBooleanList(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getBooleanList);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withBooleanList(@NonNull DriverOption option, @NonNull List<Boolean> value) {
        return this.with(option, value);
    }

    @Override
    public int getInt(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getInt);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withInt(@NonNull DriverOption option, int value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public List<Integer> getIntList(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getIntList);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withIntList(@NonNull DriverOption option, @NonNull List<Integer> value) {
        return this.with(option, value);
    }

    @Override
    public long getLong(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getLong);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withLong(@NonNull DriverOption option, long value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public List<Long> getLongList(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getLongList);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withLongList(@NonNull DriverOption option, @NonNull List<Long> value) {
        return this.with(option, value);
    }

    @Override
    public double getDouble(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getDouble);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withDouble(@NonNull DriverOption option, double value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public List<Double> getDoubleList(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getDoubleList);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withDoubleList(@NonNull DriverOption option, @NonNull List<Double> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public String getString(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getString);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withString(@NonNull DriverOption option, @NonNull String value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public List<String> getStringList(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getStringList);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withStringList(@NonNull DriverOption option, @NonNull List<String> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public Map<String, String> getStringMap(@NonNull DriverOption option) {
        Config subConfig = this.getCached(option.getPath(), this.getEffectiveOptions()::getConfig);
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (Map.Entry<String, ConfigValue> entry : subConfig.entrySet()) {
            if (!entry.getValue().valueType().equals((Object)ConfigValueType.STRING)) continue;
            builder.put(entry.getKey(), (String)entry.getValue().unwrapped());
        }
        return builder.build();
    }

    @Override
    @NonNull
    public DriverExecutionProfile withStringMap(@NonNull DriverOption option, @NonNull Map<String, String> map) {
        Base base = this.getBaseProfile();
        Config newAdded = this.getAddedOptions();
        for (String key : map.keySet()) {
            newAdded = newAdded.withValue(option.getPath() + "." + key, ConfigValueFactory.fromAnyRef(map.get(key)));
        }
        Derived derived = new Derived(base, newAdded);
        base.register(derived);
        return derived;
    }

    @Override
    public long getBytes(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getBytes);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withBytes(@NonNull DriverOption option, long value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public List<Long> getBytesList(DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getBytesList);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withBytesList(@NonNull DriverOption option, @NonNull List<Long> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public Duration getDuration(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getDuration);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withDuration(@NonNull DriverOption option, @NonNull Duration value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public List<Duration> getDurationList(@NonNull DriverOption option) {
        return this.getCached(option.getPath(), this.getEffectiveOptions()::getDurationList);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withDurationList(@NonNull DriverOption option, @NonNull List<Duration> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile without(@NonNull DriverOption option) {
        return this.with(option, null);
    }

    @Override
    @NonNull
    public Object getComparisonKey(@NonNull DriverOption option) {
        return this.getEffectiveOptions().getConfig(option.getPath());
    }

    @Override
    @NonNull
    public SortedSet<Map.Entry<String, Object>> entrySet() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(Map.Entry.comparingByKey());
        for (Map.Entry<String, ConfigValue> entry : this.getEffectiveOptions().entrySet()) {
            builder.add(new AbstractMap.SimpleEntry<String, Object>(entry.getKey(), entry.getValue().unwrapped()));
        }
        return builder.build();
    }

    private <T> T getCached(String path, Function<String, T> compute2) {
        Object t = this.cache.computeIfAbsent(path, compute2);
        return (T)t;
    }

    private DriverExecutionProfile with(@NonNull DriverOption option, @Nullable Object value) {
        Base base = this.getBaseProfile();
        Config newAdded = this.getAddedOptions().withValue(option.getPath(), ConfigValueFactory.fromAnyRef(value));
        Derived derived = new Derived(base, newAdded);
        base.register(derived);
        return derived;
    }

    @ThreadSafe
    static class Derived
    extends TypesafeDriverExecutionProfile {
        private final Base baseProfile;
        private final Config addedOptions;
        private volatile Config effectiveOptions;

        Derived(Base baseProfile, Config addedOptions) {
            this.baseProfile = baseProfile;
            this.addedOptions = addedOptions;
            this.refresh();
        }

        void refresh() {
            this.effectiveOptions = this.addedOptions.withFallback(this.baseProfile.getEffectiveOptions());
            this.cache.clear();
        }

        @Override
        @NonNull
        public String getName() {
            return this.baseProfile.getName();
        }

        @Override
        protected Base getBaseProfile() {
            return this.baseProfile;
        }

        @Override
        protected Config getAddedOptions() {
            return this.addedOptions;
        }

        @Override
        protected Config getEffectiveOptions() {
            return this.effectiveOptions;
        }
    }

    @ThreadSafe
    static class Base
    extends TypesafeDriverExecutionProfile {
        private final String name;
        private volatile Config options;
        private volatile Set<Derived> derivedProfiles;

        Base(String name, Config options) {
            this.name = name;
            this.options = options;
        }

        @Override
        @NonNull
        public String getName() {
            return this.name;
        }

        @Override
        protected Base getBaseProfile() {
            return this;
        }

        @Override
        protected Config getAddedOptions() {
            return ConfigFactory.empty();
        }

        @Override
        protected Config getEffectiveOptions() {
            return this.options;
        }

        void refresh(Config newOptions) {
            this.options = newOptions;
            this.cache.clear();
            if (this.derivedProfiles != null) {
                for (Derived derivedProfile : this.derivedProfiles) {
                    derivedProfile.refresh();
                }
            }
        }

        void register(Derived derivedProfile) {
            this.getDerivedProfiles().add(derivedProfile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<Derived> getDerivedProfiles() {
            Set<Derived> result2 = this.derivedProfiles;
            if (result2 == null) {
                Base base = this;
                synchronized (base) {
                    result2 = this.derivedProfiles;
                    if (result2 == null) {
                        this.derivedProfiles = result2 = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
                    }
                }
            }
            return result2;
        }
    }
}

