/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class BlobCodec
implements TypeCodec<ByteBuffer> {
    @Override
    @NonNull
    public GenericType<ByteBuffer> getJavaType() {
        return GenericType.BYTE_BUFFER;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.BLOB;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof ByteBuffer;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return ByteBuffer.class.equals(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable ByteBuffer value, @NonNull ProtocolVersion protocolVersion) {
        return value == null ? null : value.duplicate();
    }

    @Override
    @Nullable
    public ByteBuffer decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        return bytes == null ? null : bytes.duplicate();
    }

    @Override
    @NonNull
    public String format(@Nullable ByteBuffer value) {
        return value == null ? "NULL" : Bytes.toHexString(value);
    }

    @Override
    @Nullable
    public ByteBuffer parse(@Nullable String value) {
        return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Bytes.fromHexString(value);
    }
}

