/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class StringCodec
implements TypeCodec<String> {
    private final DataType cqlType;
    private final FastThreadLocal<CharsetEncoder> charsetEncoder;
    private final FastThreadLocal<CharsetDecoder> charsetDecoder;

    public StringCodec(@NonNull DataType cqlType, final @NonNull Charset charset) {
        this.cqlType = cqlType;
        this.charsetEncoder = new FastThreadLocal<CharsetEncoder>(){

            @Override
            protected CharsetEncoder initialValue() throws Exception {
                return charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            }
        };
        this.charsetDecoder = new FastThreadLocal<CharsetDecoder>(){

            @Override
            protected CharsetDecoder initialValue() throws Exception {
                return charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            }
        };
    }

    @Override
    @NonNull
    public GenericType<String> getJavaType() {
        return GenericType.STRING;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof String;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == String.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable String value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        try {
            return this.charsetEncoder.get().encode(CharBuffer.wrap(value));
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @Nullable
    public String decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        if (bytes.remaining() == 0) {
            return "";
        }
        try {
            return this.charsetDecoder.get().decode(bytes.duplicate()).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @NonNull
    public String format(@Nullable String value) {
        return value == null ? "NULL" : Strings.quote(value);
    }

    @Override
    @Nullable
    public String parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!Strings.isQuoted(value)) {
            throw new IllegalArgumentException("text or varchar values must be enclosed by single quotes");
        }
        return Strings.unquote(value);
    }
}

