/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.request.query.Values;
import com.datastax.oss.protocol.internal.util.Flags;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import java.nio.ByteBuffer;
import java.util.List;

public class Batch
extends Message {
    public final byte type;
    public final List<Object> queriesOrIds;
    public final List<List<ByteBuffer>> values;
    public final int consistency;
    public final int serialConsistency;
    public final long defaultTimestamp;
    public final String keyspace;
    public final int nowInSeconds;
    public final int flags;

    public Batch(int flags, byte type, List<Object> queriesOrIds, List<List<ByteBuffer>> values2, int consistency, int serialConsistency, long defaultTimestamp, String keyspace, int nowInSeconds) {
        super(false, 13);
        this.type = type;
        this.queriesOrIds = queriesOrIds;
        this.values = values2;
        this.consistency = consistency;
        this.serialConsistency = serialConsistency;
        this.defaultTimestamp = defaultTimestamp;
        this.keyspace = keyspace;
        this.nowInSeconds = nowInSeconds;
        this.flags = flags;
    }

    public Batch(byte type, List<Object> queriesOrIds, List<List<ByteBuffer>> values2, int consistency, int serialConsistency, long defaultTimestamp, String keyspace, int nowInSeconds) {
        this(Batch.computeFlags(serialConsistency, defaultTimestamp, keyspace, nowInSeconds), type, queriesOrIds, values2, consistency, serialConsistency, defaultTimestamp, keyspace, nowInSeconds);
    }

    public String toString() {
        return "BATCH(" + this.queriesOrIds.size() + " statements)";
    }

    protected static int computeFlags(int serialConsistency, long defaultTimestamp, String keyspace, int nowInSeconds) {
        int flags = 0;
        if (serialConsistency != 8) {
            flags = Flags.add(flags, 16);
        }
        if (defaultTimestamp != Long.MIN_VALUE) {
            flags = Flags.add(flags, 32);
        }
        if (keyspace != null) {
            flags = Flags.add(flags, 128);
        }
        if (nowInSeconds != Integer.MIN_VALUE) {
            flags = Flags.add(flags, 256);
        }
        return flags;
    }

    public static class Codec
    extends Message.Codec {
        public Codec(int protocolVersion) {
            super(13, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            Batch batch = (Batch)message;
            encoder.writeByte(batch.type, dest);
            int queryCount = batch.queriesOrIds.size();
            encoder.writeUnsignedShort(queryCount, dest);
            for (int i = 0; i < queryCount; ++i) {
                Object q = batch.queriesOrIds.get(i);
                if (q instanceof String) {
                    encoder.writeByte((byte)0, dest);
                    encoder.writeLongString((String)q, dest);
                } else {
                    encoder.writeByte((byte)1, dest);
                    encoder.writeShortBytes((byte[])q, dest);
                }
                Values.writePositionalValues(batch.values.get(i), dest, encoder);
            }
            encoder.writeUnsignedShort(batch.consistency, dest);
            if (this.protocolVersion >= 5) {
                encoder.writeInt(batch.flags, dest);
            } else {
                encoder.writeByte((byte)batch.flags, dest);
            }
            if (Flags.contains(batch.flags, 16)) {
                encoder.writeUnsignedShort(batch.serialConsistency, dest);
            }
            if (Flags.contains(batch.flags, 32)) {
                encoder.writeLong(batch.defaultTimestamp, dest);
            }
            if (Flags.contains(batch.flags, 128)) {
                encoder.writeString(batch.keyspace, dest);
            }
            if (Flags.contains(batch.flags, 256)) {
                encoder.writeInt(batch.nowInSeconds, dest);
            }
        }

        @Override
        public int encodedSize(Message message) {
            Batch batch = (Batch)message;
            int size = 1;
            size += 2;
            int queryCount = batch.queriesOrIds.size();
            ProtocolErrors.check(queryCount <= 65535, "Batch messages can contain at most %d queries", 65535);
            ProtocolErrors.check(batch.values.size() == queryCount, "Batch contains %d queries but %d value lists", queryCount, batch.values.size());
            for (int i = 0; i < queryCount; ++i) {
                Object q = batch.queriesOrIds.get(i);
                size += 1 + (q instanceof String ? PrimitiveSizes.sizeOfLongString((String)q) : PrimitiveSizes.sizeOfShortBytes((byte[])q));
                size += Values.sizeOfPositionalValues(batch.values.get(i));
            }
            size += 2;
            size += this.protocolVersion >= 5 ? 4 : 1;
            if (Flags.contains(batch.flags, 16)) {
                size += 2;
            }
            if (Flags.contains(batch.flags, 32)) {
                size += 8;
            }
            if (Flags.contains(batch.flags, 128)) {
                size += PrimitiveSizes.sizeOfString(batch.keyspace);
            }
            if (Flags.contains(batch.flags, 256)) {
                size += 4;
            }
            return size;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            byte type = decoder.readByte(source);
            int queryCount = decoder.readUnsignedShort(source);
            NullAllowingImmutableList.Builder<Object> queriesOrIds = NullAllowingImmutableList.builder(queryCount);
            NullAllowingImmutableList.Builder<List<ByteBuffer>> values2 = NullAllowingImmutableList.builder(queryCount);
            for (int i = 0; i < queryCount; ++i) {
                boolean isQueryString = decoder.readByte(source) == 0;
                queriesOrIds.add(isQueryString ? decoder.readLongString(source) : (Object)decoder.readShortBytes(source));
                values2.add(Values.readPositionalValues(source, decoder));
            }
            int consistency = decoder.readUnsignedShort(source);
            int flags = this.protocolVersion >= 5 ? decoder.readInt(source) : (int)decoder.readByte(source);
            int serialConsistency = Flags.contains(flags, 16) ? decoder.readUnsignedShort(source) : 8;
            long defaultTimestamp = Flags.contains(flags, 32) ? decoder.readLong(source) : Long.MIN_VALUE;
            String keyspace = Flags.contains(flags, 128) ? decoder.readString(source) : null;
            int nowInSeconds = Flags.contains(flags, 256) ? decoder.readInt(source) : Integer.MIN_VALUE;
            return new Batch(flags, type, queriesOrIds.build(), values2.build(), consistency, serialConsistency, defaultTimestamp, keyspace, nowInSeconds);
        }
    }
}

