/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;
import jnr.posix.BaseFileStat;
import jnr.posix.NanosecondFileStat;
import jnr.posix.NativePOSIX;

public final class FreeBSDFileStat12
extends BaseFileStat
implements NanosecondFileStat {
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());

    public FreeBSDFileStat12(NativePOSIX posix) {
        super(posix, layout);
    }

    @Override
    public long atime() {
        return FreeBSDFileStat12.layout.st_atime.get(this.memory);
    }

    @Override
    public long blocks() {
        return FreeBSDFileStat12.layout.st_blocks.get(this.memory);
    }

    @Override
    public long blockSize() {
        return FreeBSDFileStat12.layout.st_blksize.get(this.memory);
    }

    @Override
    public long ctime() {
        return FreeBSDFileStat12.layout.st_ctime.get(this.memory);
    }

    @Override
    public long dev() {
        return FreeBSDFileStat12.layout.st_dev.get(this.memory);
    }

    @Override
    public int gid() {
        return FreeBSDFileStat12.layout.st_gid.get(this.memory);
    }

    @Override
    public long ino() {
        return FreeBSDFileStat12.layout.st_ino.get(this.memory);
    }

    @Override
    public int mode() {
        return FreeBSDFileStat12.layout.st_mode.get(this.memory) & 0xFFFF;
    }

    @Override
    public long mtime() {
        return FreeBSDFileStat12.layout.st_mtime.get(this.memory);
    }

    @Override
    public int nlink() {
        return FreeBSDFileStat12.layout.st_nlink.get(this.memory);
    }

    @Override
    public long rdev() {
        return FreeBSDFileStat12.layout.st_rdev.get(this.memory);
    }

    @Override
    public long st_size() {
        return FreeBSDFileStat12.layout.st_size.get(this.memory);
    }

    @Override
    public int uid() {
        return FreeBSDFileStat12.layout.st_uid.get(this.memory);
    }

    @Override
    public long aTimeNanoSecs() {
        return FreeBSDFileStat12.layout.st_atimensec.get(this.memory);
    }

    @Override
    public long cTimeNanoSecs() {
        return FreeBSDFileStat12.layout.st_ctimensec.get(this.memory);
    }

    @Override
    public long mTimeNanoSecs() {
        return FreeBSDFileStat12.layout.st_mtimensec.get(this.memory);
    }

    private static final class Layout
    extends StructLayout {
        public final dev_t st_dev = new dev_t();
        public final StructLayout.Signed64 st_ino = new StructLayout.Signed64(this);
        public final StructLayout.Signed32 st_nlink_upper = new StructLayout.Signed32(this);
        public final StructLayout.Signed32 st_nlink = new StructLayout.Signed32(this);
        public final StructLayout.Signed16 st_mode = new StructLayout.Signed16(this);
        public final StructLayout.Signed16 st_padding0 = new StructLayout.Signed16(this);
        public final StructLayout.Signed32 st_uid = new StructLayout.Signed32(this);
        public final StructLayout.Signed32 st_gid = new StructLayout.Signed32(this);
        public final StructLayout.Signed32 st_padding1 = new StructLayout.Signed32(this);
        public final dev_t st_rdev = new dev_t();
        public final time_t st_atime = new time_t();
        public final StructLayout.SignedLong st_atimensec = new StructLayout.SignedLong(this);
        public final time_t st_mtime = new time_t();
        public final StructLayout.SignedLong st_mtimensec = new StructLayout.SignedLong(this);
        public final time_t st_ctime = new time_t();
        public final StructLayout.SignedLong st_ctimensec = new StructLayout.SignedLong(this);
        public final time_t st_birthtime = new time_t();
        public final StructLayout.SignedLong st_birthtimensec = new StructLayout.SignedLong(this);
        public final StructLayout.Signed64 st_size = new StructLayout.Signed64(this);
        public final StructLayout.Signed64 st_blocks = new StructLayout.Signed64(this);
        public final StructLayout.Signed32 st_blksize = new StructLayout.Signed32(this);
        public final StructLayout.Signed32 st_flags = new StructLayout.Signed32(this);
        public final StructLayout.Signed64 st_gen = new StructLayout.Signed64(this);
        public final StructLayout.Signed64 st_qspare0 = new StructLayout.Signed64(this);

        private Layout(Runtime runtime) {
            super(runtime);
        }

        public final class dev_t
        extends StructLayout.Signed32 {
            public dev_t() {
                super(Layout.this);
            }
        }

        public final class time_t
        extends StructLayout.SignedLong {
            public time_t() {
                super(Layout.this);
            }
        }
    }
}

