/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JdbcPatternParser {
    private static final String QUESTION_MARK = "?";
    private static final char PERCENT_CHAR = '%';
    private static final Pattern STRING_LITERAL_PATTERN = Pattern.compile("'((?>[^']|'')+)'");
    private String parameterizedSql;
    private final List<String> patternStringRepresentationList = new ArrayList<String>();
    private final List<PatternConverter> args = new ArrayList<PatternConverter>();

    JdbcPatternParser(String insertString) {
        this.init(insertString);
    }

    public String getParameterizedSql() {
        return this.parameterizedSql;
    }

    public List<String> getUnmodifiablePatternStringRepresentationList() {
        return Collections.unmodifiableList(this.patternStringRepresentationList);
    }

    public String toString() {
        return "JdbcPatternParser{sql=" + this.parameterizedSql + ",args=" + this.patternStringRepresentationList + "}";
    }

    private void init(String insertString) {
        if (insertString == null) {
            throw new IllegalArgumentException("Null pattern");
        }
        Matcher m4 = STRING_LITERAL_PATTERN.matcher(insertString);
        StringBuffer sb = new StringBuffer();
        while (m4.find()) {
            String matchedStr = m4.group(1);
            if (matchedStr.indexOf(37) == -1) {
                this.replaceWithMatchedStr(m4, sb);
                continue;
            }
            this.replaceWithBind(m4, sb, matchedStr);
        }
        m4.appendTail(sb);
        this.parameterizedSql = sb.toString();
    }

    private void replaceWithMatchedStr(Matcher m4, StringBuffer sb) {
        m4.appendReplacement(sb, "'$1'");
    }

    private void replaceWithBind(Matcher m4, StringBuffer sb, String matchedStr) {
        m4.appendReplacement(sb, QUESTION_MARK);
        matchedStr = matchedStr.replaceAll("''", "'");
        this.patternStringRepresentationList.add(matchedStr);
        this.args.add(new PatternParser(matchedStr).parse());
    }

    public void setParameters(PreparedStatement ps, LoggingEvent logEvent) throws SQLException {
        for (int i = 0; i < this.args.size(); ++i) {
            PatternConverter head = this.args.get(i);
            String value = this.buildValueStr(logEvent, head);
            ps.setString(i + 1, value);
        }
    }

    private String buildValueStr(LoggingEvent logEvent, PatternConverter head) {
        StringBuffer buffer = new StringBuffer();
        PatternConverter c = head;
        while (c != null) {
            c.format(buffer, logEvent);
            c = c.next;
        }
        return buffer.toString();
    }
}

