/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.nbformat;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.jupyter.types.JupyterOutputType;
import org.apache.zeppelin.jupyter.types.ZeppelinOutputType;
import org.apache.zeppelin.jupyter.zformat.TypeData;

public abstract class Output {
    @SerializedName(value="output_type")
    private String outputType;
    private static final transient String lineSeparator = System.lineSeparator();

    public static List<String> verifyEndOfLine(List<String> content) {
        if (null == content || content.size() == 1) {
            return content;
        }
        for (int i = 0; i < content.size(); ++i) {
            String line = content.get(i);
            if (null == line || line.endsWith(lineSeparator) || i == content.size() - 1) continue;
            content.set(i, line + lineSeparator);
        }
        return content;
    }

    protected JupyterOutputType getType(Map<String, Object> data) {
        JupyterOutputType jupyterOutputType = JupyterOutputType.TEXT_PLAIN;
        if (data == null) {
            return null;
        }
        for (String dataType : data.keySet()) {
            if (dataType.equals(JupyterOutputType.TEXT_PLAIN.toString())) continue;
            try {
                jupyterOutputType = JupyterOutputType.getByValue(dataType);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return jupyterOutputType;
    }

    protected TypeData getZeppelinResult(Map<String, Object> data, JupyterOutputType type) {
        TypeData result = null;
        Object outputsObject = data.get(type.toString());
        ArrayList<String> outputsRaws = new ArrayList<String>();
        if (outputsObject instanceof String) {
            outputsRaws.add((String)outputsObject);
        } else {
            outputsRaws.addAll((List)outputsObject);
        }
        List<String> outputs = Output.verifyEndOfLine(outputsRaws);
        String outputData = StringUtils.join(outputs, (String)"");
        if (type == JupyterOutputType.IMAGE_PNG) {
            String base64CodeRaw = outputData;
            String base64Code = base64CodeRaw.replace("\n", "");
            result = new TypeData(type.getZeppelinType().toString(), ZeppelinResultGenerator.toBase64ImageHtmlElement(base64Code));
        } else {
            result = type == JupyterOutputType.LATEX ? new TypeData(type.getZeppelinType().toString(), ZeppelinResultGenerator.toLatex(outputData)) : (type == JupyterOutputType.APPLICATION_JAVASCRIPT ? new TypeData(type.getZeppelinType().toString(), ZeppelinResultGenerator.toJavascript(outputData)) : new TypeData(type.getZeppelinType().toString(), outputData));
        }
        return result;
    }

    public abstract ZeppelinOutputType getTypeOfZeppelin();

    public abstract TypeData toZeppelinResult();

    private static class ZeppelinResultGenerator {
        private ZeppelinResultGenerator() {
        }

        public static String toBase64ImageHtmlElement(String image) {
            return "<div style='width:auto;height:auto'><img src=data:image/png;base64," + image + " style='width=auto;height:auto'/></div>";
        }

        public static String toLatex(String latexCode) {
            String latexContents = latexCode;
            return "<div><div>" + latexContents + "</div></div>";
        }

        public static String toJavascript(String javascriptCode) {
            return "<script type='application/javascript'>" + javascriptCode + "</script>";
        }
    }
}

