/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cluster.listener;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinClusterMembershipEventListener
implements ClusterMembershipEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinClusterMembershipEventListener.class);

    public void event(ClusterMembershipEvent event) {
        switch ((ClusterMembershipEvent.Type)event.type()) {
            case MEMBER_ADDED: {
                LOGGER.info("{} joined the cluster.", (Object)((Member)event.subject()).id());
                break;
            }
            case MEMBER_REMOVED: {
                LOGGER.info("{} left the cluster.", (Object)((Member)event.subject()).id());
                break;
            }
            case METADATA_CHANGED: {
                LOGGER.info("{} meta data changed.", (Object)((Member)event.subject()).id());
                break;
            }
            case REACHABILITY_CHANGED: {
                LOGGER.info("{} reachability changed.", (Object)((Member)event.subject()).id());
            }
        }
    }
}

